// Amp FQ models for Kemet 0402 COG capacitors - data read from Kemet Spice
pF=1.0E-12;
nH=1.0E-9;
MHz=1.0E+6;
GHz=1.0E+9;

// E12 = [0.10, 0.12, 0.15, 0.18, 0.22, 0.27, 0.33, 0.39, 0.47, 0.56, 0.68, 0.82];

Cm=[ 0.5; 1.00; 1.2; 1.5;  1.8; 2.2;   2.7;  3.3;  3.9;  4.7;  5.6;  6.8;  8.2; 10.0]*pF;
Rc=[1.30; 1.20; 1.1; 1.1; 0.99; 0.86; 0.51; 0.65; 0.61; 0.54; 0.47; 0.47; 0.38; 0.33];
Fc=[10.0;  7.2; 6.3; 5.7;  5.2;  4.5;  4.2;  3.6;  3.3;  3.0;  2.5;  2.3;  2.1;  1.8]*GHz;

Wc=2*%pi*Fc;
Lc=(1.0)./Wc./Wc./Cm;
Qc=Wc.*Lc./Rc;
C_FQ=[Cm,Fc,Qc];
FQc=[Fc,Qc];

function [fc,qc] = _FQ_C_Mod(cap)
  if cap <= Cm(1)
    fc=Fc(1);
    qc=Qc(1);
  elseif cap > Cm($)
    fc=Fc($);
    qc=Qc($);
  else  
    fq = interp1(Cm,FQc,cap);
    fc=fq(1);
    qc=fq(2);
  end
endfunction

function [fc,qc] = FQ_C_Models(caps)
 N = max(size(caps)); 
 Fc=zeros(N,1);
 Qc=zeros(N,1);
 for n=1:N
  [fc(n,1),qc(n,1)] = _FQ_C_Mod(caps(n));
 end 
endfunction

// Amp FQ models for Murrata TN -  chip inductors

Lm  = [ 1.1; 1.6;  1.8; 2.4; 2.7;  3.3; 3.9; 4.7; 5.6; 6.8; 8.2; 10.0; 12.0; 15.0; 18.0; 22.0]*nH;
qf =  [   8;   8;    8;   8;   8;    8;   8;   8;   8;   8;   8;    8;    8;    7;    7;    6];
Fl = [ 14.8;  12; 11.3; 9.5; 9.2; 10.4; 9.7; 8.6; 7.5; 7.4; 6.2;  5.3;  4.4;  3.8;  3.4;  3.0]*GHz;

// freq for Q spec 
Fq=500*MHz;
wq=2*%pi*Fq;

Rq=wq.*Lm./qf;
// increase of R due to skin effect 
R=Rq.*sqrt(Fl./Fq);
Wl=2*%pi*Fl;
Ql=Wl.*Lm./R;
L_FQ=[Lm,Fl,Ql];
FQl=[Fl,Ql];

function [fl,ql] = _FQ_L_Mod(ind)
  if ind <= Lm(1)
    fl=Fl(1);
    ql=Ql(1);
  elseif ind > Lm($)
    fl=Fl($);
    ql=Ql($);
  else  
    fq = interp1(Lm,FQl,ind);
    fl=fq(1);
    ql=fq(2);
  end
endfunction

function [fl,ql] = FQ_L_Models(inds)
 N = max(size(inds)); 
 Fc=zeros(N,1);
 Qc=zeros(N,1);
 for n=1:N
  [fl(n,1),ql(n,1)] = _FQ_L_Mod(inds(n));
 end 
endfunction

