if filename1$=="" then abort; end;
if filename2$=="" then abort; end; 

// 
h_fig0=scf(0);    // create window 0
h_fig0.figure_position=[40,22];
h_fig0.figure_size=[450*1.5,300*1.5];
xbasc();

MHz=1.0E+6;

Mat1=read(filename1$,-1,3);
[R1,C1]=size(Mat1)
Mat2=read(filename2$,-1,3);
[R2,C2]=size(Mat2)

i1=1:R1;
f1(i1)=Mat1(i1,1);
TF1_re(i1)=Mat1(i1,2);
TF1_im(i1)=Mat1(i1,3);
TF1(i1)=TF1_re(i1)+%i*TF1_im(i1);
[db1,phi1]=dbphi(TF1);
TF1_ph(i1)=phi1(i1);
TF1_db(i1)=db1(i1);

i2=1:R2;
f2(i2)=Mat2(i2,1);
TF2_re(i2)=Mat2(i2,2);
TF2_im(i2)=Mat2(i2,3);
TF2(i2)=TF2_re(i2)+%i*TF2_im(i2);
[db2,phi2]=dbphi(TF2);
TF2_ph(i2)=phi2(i2);
TF2_db(i2)=db2(i2);

vect=ones(max(size(f1)),1);
scf(h_fig0);

if (dBph) 
 subplot(2,1,1);
end
plot2d(f1/MHz, TF1_db+dBoffset, style=5);
plot2d(f2/MHz, TF2_db+dBoffset, style=2);
xgrid();
legend([TF1$,+TF2$],3);

if (dBph)
  subplot(2,1,2);
  plot2d(f1/MHz, TF1_ph, style=5);
  plot2d(f2/MHz, TF2_ph, style=2);
  xgrid();
end  


