// return column vector
function y=find_dataname_indexes(TF$)
  // y=grep(DN,TF$); 
  // this might be K_U1_V1 but also S_K_U1_V1_R1
  y= find(DN(:)==TF$)
endfunction

// returns column vector
function y=find_param(PARAM$)
  y=grep(PN(1,:),PARAM$);  // parameters names are the same, search only the first run
endfunction

// returns column vector
function y=find_param_value_indexes(x,p)
 eps=1.0E-15;
 y=find(abs(PV(:,p)-x)<eps);
endfunction

// returns column vector
function y=find_common_indexes(is1,is2)
  y=[];
  if ((length(is1)== 0) | (length(is2) == 0)) then return; end; 
  k=1;
  for i1=1:length(is1), // set1
    for i2=1:length(is2), // set2
      if (is1(i1) == is2(i2))
        y(1,k)=is1(i1);
        k=k+1;
      end        
    end  
  end  
endfunction

// ----------------------------------------------------------

function index = parse_m0(fname$, N_PARAM)
global Tmajor Tmiddle Tminor Tname FN DN FD PN PV

  // reset scans
  Tmajor=[];
  Tmiddle=[];
  Tminor=[];
  Tname=[]; 
  FN=[];
  DN=[];
  FD=[];
  PN=[];
  PV=[];
  
  fhd=mopen(fname$,'r');
  index=1;
  while ( meof(fhd)==0 ) do
    [nx,Tmajor(index),Tmiddle(index),Tminor(index)]=mfscanf(fhd,"TASK:%d.%d.%d");
    Tname(index)=mfscanf(fhd,"%s \n"); 
    FN(index)=mfscanf(fhd,"FILE: %s \n ");
    DN(index)=mfscanf(fhd,"DATANAME: %s \n");
    FD(index)=mfscanf(fhd,"DATA: %s \n ");  
    if (N_PARAM >0) 
      mfscanf(fhd,"PARAMETERS:\n");
      p=1;
      while p <= N_PARAM  do
        PN(index,p) = stripblanks(mfscanf(fhd,"%s = "));
        PV(index,p) = mfscanf(fhd," %f \n");
        p=p+1;
      end  
    end  
    mfscanf(fhd,"EOF\n");  
    index=index+1;
  end;
  //close the *.m0 file
  mclose(fhd); 
  index=index-1;
endfunction

function index = find_tf_param_index(tf$, pn$, pv )
  iset1=find_dataname_indexes(tf$)
  iset2=find_param_value_indexes(pv,find_param(pn$))
  // tf$ && pn$ = pv
  index = find_common_indexes(iset1,iset2)
endfunction

function err = run(exe$, path$, input$)
 // run in exe with input in path folder  
 err = host("pushd " + path$ + " && " + exe$ + " " + input$ + " && " + "pushd"  );
// if (err <> 0) then abort; end;
endfunction  

function index = parse_vx(fname$)
global XN XV

  fhd=mopen(fname$,'r');
  index=1;
  while ( meof(fhd)==0 ) do
    XN(index) = stripblanks(mfscanf(fhd,"%s = "));
    XV(index) = mfscanf(fhd," %f ;\n");
    index=index+1;
  end;
  //close the *.m0 file
  mclose(fhd); 
  index=index-1;
endfunction

// ----------------------------------------------------------
// get TF files using index of DN array
global Tmajor Tmiddle Tminor Tname FN DN FD PN PV
global XN XV

