// transition band aproximation defined by a line connecting two points
// TB_Att_dB @ TB_FREQ
// ST_Att_dB @ ST_FREQ - stop band 
function error_dB = TB_aprox_err_dB(f,tfdB)
  error_dB = 0.0;
endfunction  

// stop band error
function error_dB = SB_aprox_err_dB(f,tfdB)
  error_dB = 0.0; 
  sb_indexes= find(f(:)>=ST_FREQ)
  for sb=sb_indexes
    if tfdB(sb) > ST_Att_dB then     
     error_dB = error_dB +  SB_Weight*(tfdB(sb) - ST_Att_dB);       // -10 -(-20)=
    end
  end
endfunction  

// pass band error
function error_dB = PB_aprox_err_dB(f,tfdB)
  error_dB = 0.0;
  lp_indexes= find(f(:)<=LP_FREQ)
  for lp=lp_indexes
    if tfdB(lp) > PB_Ripples_dB then     
     error_dB = error_dB + PB_Weight*(tfdB(lp) - PB_Ripples_dB);    // 0.6-0.5=0.1
    elseif tfdB(lp) < -PB_Ripples_dB
     error_dB = error_dB + PB_Weight*(- PB_Ripples_dB - tfdB(lp)); // -0.5-(-0.6)=0.1
    end
  end
endfunction

