// transition band aproximation defined by a line connecting two points
// TB_Att_dB @ TB_FREQ
// ST_Att_dB @ ST_FREQ - stop band 
function error_dB = TB_aprox_err_dB(f,tfdB)
  // aproximation is linear for att in dB and log10(f)
  // y=a(x-xo)+yo | x = log10(f)
  a = (TB_Att_dB - ST_Att_dB)/(log10(TB_FREQ/ST_FREQ)); 
  tb_indexes= find(f(:)>=TB_FREQ ) 
  tb_indexes= find( f(tb_indexes)<=ST_FREQ)
  K=max(size(tb_indexes));
  errors= zeros(K,1);
  for k=1:K
    tb=tb_indexes(k)    
    Att_dB = a*(log10(f(tb)/TB_FREQ))+TB_Att_dB; 
    if tfdB(tb) > Att_dB then     
     errors(k) = TB_Weight*(tfdB(tb) - Att_dB);       // -10 -(-20)=
    else
     errors(k) = 0.0 
    end
   end
   error_dB = max(errors);
endfunction  

// stop band error
function error_dB = SB_aprox_err_dB(f,tfdB)   
  sb_indexes= find(f(:)>=ST_FREQ);
  K=max(size(sb_indexes));
  errors= zeros(K,1);  
  for k=1:K
     sb=sb_indexes(k)
     if tfdB(sb) > ST_Att_dB then     
       errors(k) = SB_Weight*(tfdB(sb) - ST_Att_dB);       // -10 -(-20)=
     else
       errors(k) = 0.0;
     end
  end
  error_dB = max(errors);
endfunction  

// pass band error
function error_dB = PB_aprox_err_dB(f,tfdB)
  
  lp_indexes= find(f(:)<=LP_FREQ)
  K=max(size(lp_indexes));
  errors= zeros(K,1);
  for k=1:K
    lp = lp_indexes(k);
    if tfdB(lp) > PB_Ripples_dB then     
     errors(k) =  PB_Weight*(tfdB(lp) - PB_Ripples_dB);    // 0.6-0.5=0.1
    elseif tfdB(lp) < -PB_Ripples_dB
     errors(k) =  PB_Weight*(- PB_Ripples_dB - tfdB(lp)); // -0.5-(-0.6)=0.1
    else
     errors(k) = 0.0;
    end  
  end
  error_dB = max(errors);
endfunction

