// prefered numbers toolbox

// 10%
E6 = [0.10,                0.15,               0.22,               0.33,              0.47,                0.68                1.0];
// 10%
E12 = [0.10,     0.12,     0.15,     0.18,     0.22,     0.27,     0.33,     0.39,    0.47,     0.56,      0.68,     0.82,     1.0];
// 5%
E24 = [0.10,0.11,0.12,0.13,0.15,0.16,0.18,0.20,0.22,0.24,0.27,0.30,0.33,0.36,0.39,0.43,0.47,0.51,0.56,0.62,0.68,0.75,0.82,0.91,1.0];

function y = exp10(x)
  y = int(log10(x));
endfunction  

function [n,p] = norm10(x)
  p=exp10(abs(x));
  if (x >= 1.0)
    p=p+1;
  end  
  n =x/(10^p);
endfunction

// greater than
function y = gt(x, numb_v)
 i = find(numb_v > x);
 if i<>[] 
    y = numb_v(min(i));
 else
    y = numb_v($);
 end 
  
endfunction

// less than
function y = leq(x, numb_v)
 i = find(numb_v <= x);
 if i<>[] 
    y = numb_v(max(i));
 else
    y = numb_v(0);
 end  
endfunction

// calc prefered norm_numer
// opt - closest
// lt - smaller
// ygt - bigger
function [yopt, ylt, ygt] = p_norm(x, numb_v)
 ylt = leq(x, numb_v);
 ygt = gt(x, numb_v);
 if (ygt-x) < (x-ylt) 
  yopt = ygt;
 else
  yopt = ylt; 
 end 
endfunction

function [yopt, ylt, ygt] = pref_numb(x, numb_v)
 [n,p]= norm10(x); // x=n*10^p, n=[0..0.999999]
  [nopt, nlt, ngt] = p_norm(n, numb_v);
  yopt = nopt*(10^p);
  ylt = nlt*(10^p);
  ygt  = ngt*(10^p);
endfunction

// this function converts uint into vector of p-bits 0/1
function b = __p_bitvect(x,p) 
    
    if x>=2^p then error('__p_bitvect32 - Dimension');
    end
    for i = 1:p
      b(i,1) = pmodulo(x,2);
      x = floor (x ./ 2);
    end
endfunction

// this function converts uint32 into vector of bits 0/1
function b = bitvect32(x) 
    b= __p_bitvect(x,32);
endfunction

// this function converts uint16 into vector of bits 0/1
function b = bitvect16(x) 
    b= __p_bitvect(x,16);
endfunction

// this function converts uint8 into vector of bits 0/1
function b = bitvect8(x) 
    b= __p_bitvect(x,8);
endfunction

function b = bitmat(x,w)
    N = max(size(x));
    b=zeros(N,w);
    for n=1:N
        b32 = bitvect32(x(n));
        b(n,:)=b32(1:w)'
    end    
endfunction    

