// ----------------------------------------------------------

function S_i=Cmplx_interpln(f,S,f_i)
// reference matrix - must have 2 rows! -  so Transpose
  f_reS=[f,real(S)]';
  f_imS=[f,imag(S)]';
  reS_i=interpln(f_reS,f_i);
  imS_i=interpln(f_imS,f_i);
  S_i=(reS_i+%i*imS_i).'; // watch for complex transpose buddy
endfunction

// ----------------------------------------------------------

function [f,S] = s_p_file(s_p_filename$)
  
    // extract raw data from Touchstone file
    ifhd=mopen(s_p_filename$,'r');
    temp_data$ = '_tmp.dat';    
    ofhd=mopen(temp_data$,'w');
    format_found_flag = 0;
    while ( meof(ifhd)==0 ) do
       line$ =  mgetl(ifhd,1); // read one line 
       if format_found_flag == 0       
          if ( strindex(line$,'#')) // find format
            // # GHZ S MA R 50
            [hash$, Hz$, MAT$, FRMT$, R$, R0]=sscanf(line$,"%s %s %s %s %s %d");
            format_found_flag = 1;
          end;    
       else
          if ( strindex(line$,'!') ==[]) // copy data line by line after, skip comments  
            mputl(line$, ofhd);        
          end;  
       end;
    end;
    mclose(ifhd);
    mclose(ofhd);

    [path$,fname$,ext$]=fileparts(s_p_filename$);
    //ext = .s2p
    n= evstr(part(ext$,3)); //  you can't just use ext(3)
    select (part(Hz$,1))
      case 'g' then
         Funit = 1.0E+9;
      case 'G' then
         Funit = 1.0E+9;
      case 'M' then   
         Funit = 1.0E+6;
      case 'm' then   
         Funit = 1.0E+6;
      case 'K' then   
         Funit = 1.0E+3;
      case 'k' then   
         Funit = 1.0E+3;
      case 'H' then
         Funit = 1.0;
      case 'h' then
         Funit = 1.0;
      else
        printf('Unknown parameter Hz$ = %s', Hz$);
    end

    // n is a size of s matrix 
    // the data size is n*n*2 + 1 (for freq)
    Mat=read(temp_data$,-1, n*n*2+1);
    [N,K]=size(Mat)
    i=1:N;
    if ((n==1) & (FRMT$ == 'MA')) 
    // format f |s11| arg(s11)  
      printf('S parameters: n=1 FRMT$=MA \n');
        f(i) = Mat(i,1).*Funit;
      s11(i) = Mat(i,2).*exp(Mat(i,3)/180*%pi*%i);
      
    elseif ((n==1) & (FRMT$ == 'DB')) 
    // format f dB(s11) arg(s11)
      printf('S parameters: n=1 FRMT$=DB \n');
        f(i) = Mat(i,1).*Funit;
      s11(i) = 10.^(Mat(i,2)./20).*exp(Mat(i,3)/180*%pi*%i);
      
    elseif ((n==1) & (FRMT$ == 'RI')) 
    // format f Re(s11) Im(s11) 
      printf('S parameters: n=1 FRMT$=RI \n');
        f(i) = Mat(i,1).*Funit;
      s11(i) = Mat(i,2) + %i.*Mat(i,3);
      
    elseif ((n==2) & (FRMT$ == 'MA')) 
    // format f |s11| arg(s11) |s21| arg(s21) |s12| arg(s12) |s22| arg(s22)
      printf('S parameters: n=2 FRMT$=MA \n');
        f(i) = Mat(i,1).*Funit;
      s11(i) = Mat(i,2).*exp(Mat(i,3)/180*%pi*%i);
      s12(i) = Mat(i,6).*exp(Mat(i,7)/180*%pi*%i);
      s21(i) = Mat(i,4).*exp(Mat(i,5)/180*%pi*%i);
      s22(i) = Mat(i,8).*exp(Mat(i,9)/180*%pi*%i);
      
    elseif ((n==2) & (FRMT$ == 'DB')) 
    // format f dB(s11) arg(s11) dB(s21) arg(s21) dB(s12) arg(s12) dB(s22) arg(s22)
      printf('S parameters: n=2 FRMT$=DB \n');
        f(i) = Mat(i,1).*Funit;
      s11(i) = 10.^(Mat(i,2)./20).*exp(Mat(i,3)/180*%pi*%i);
      s12(i) = 10.^(Mat(i,6)./20).*exp(Mat(i,7)/180*%pi*%i);
      s21(i) = 10.^(Mat(i,4)./20).*exp(Mat(i,5)/180*%pi*%i);
      s22(i) = 10.^(Mat(i,8)./20).*exp(Mat(i,9)/180*%pi*%i);
      
    elseif ((n==2) & (FRMT$ == 'RI')) 
    // format f Re(s11) Im(s11) Re(s21) Im(s21) Re(s12) Im(s12) Re(s22) arg(s22)
      printf('S parameters: n=2 FRMT$=RI \n');
        f(i) = Mat(i,1).*Funit;
      s11(i) = Mat(i,2) + %i.*Mat(i,3);
      s21(i) = Mat(i,4) + %i.*Mat(i,5);
      s12(i) = Mat(i,6) + %i.*Mat(i,7);
      s22(i) = Mat(i,8) + %i.*Mat(i,9);
      
    elseif ((n==3) & (FRMT$ == 'RI'))
    // read file - format
    //  f   Re(s11) Im(s11) Re(s12) Im(s12) Re(s13) Im(s13)  
    //      Re(s21) Im(s21) Re(s22) Im(s22) Re(s23) Im(s23)  
    //      Re(s31) Im(s31) Re(s32) Im(s33) Re(s33) Im(s33)  
      printf('S parameters: n=3 FRMT$=RI \n');
      f(i) = Mat(i,1).*Funit;
      row=1;
      s11(i) = Mat(i,2+(row-1)*6)+%i*Mat(i,3+(row-1)*6);
      s12(i) = Mat(i,4+(row-1)*6)+%i*Mat(i,5+(row-1)*6);
      s13(i) = Mat(i,6+(row-1)*6)+%i*Mat(i,7+(row-1)*6);
      row=2;
      s21(i) = Mat(i,2+(row-1)*6)+%i*Mat(i,3+(row-1)*6);
      s22(i) = Mat(i,4+(row-1)*6)+%i*Mat(i,5+(row-1)*6);
      s23(i) = Mat(i,6+(row-1)*6)+%i*Mat(i,7+(row-1)*6);
      row=3;
      s31(i) = Mat(i,2+(row-1)*6)+%i*Mat(i,3+(row-1)*6);
      s32(i) = Mat(i,4+(row-1)*6)+%i*Mat(i,5+(row-1)*6);
      s33(i) = Mat(i,6+(row-1)*6)+%i*Mat(i,7+(row-1)*6);
      
    elseif ((n==3) & (FRMT$ == 'MA'))
    //  f   abs(s11) ph(s11) abs(s12) ph(s12) abs(s13) ph(s13) 
    //      abs(s21) ph(s21) abs(s22) ph(s22) abs(s23) ph(s23) 
    //      abs(s31) ph(s31) abs(s32) ph(s33) abs(s33) ph(s33) 
      printf('S parameters: n=3 FRMT$=MA \n');
      f(i) = Mat(i,1).*Funit;
      row=1;
      s11(i) = Mat(i,2+(row-1)*6).*exp(%i*%pi/180.0*Mat(i,3+(row-1)*6));
      s12(i) = Mat(i,4+(row-1)*6).*exp(%i*%pi/180.0*Mat(i,5+(row-1)*6));
      s13(i) = Mat(i,6+(row-1)*6).*exp(%i*%pi/180.0*Mat(i,7+(row-1)*6));
      row=2;
      s21(i) = Mat(i,2+(row-1)*6).*exp(%i*%pi/180.0*Mat(i,3+(row-1)*6));
      s22(i) = Mat(i,4+(row-1)*6).*exp(%i*%pi/180.0*Mat(i,5+(row-1)*6));
      s23(i) = Mat(i,6+(row-1)*6).*exp(%i*%pi/180.0*Mat(i,7+(row-1)*6));
      row=3;
      s31(i) = Mat(i,2+(row-1)*6).*exp(%i*%pi/180.0*Mat(i,3+(row-1)*6));
      s32(i) = Mat(i,4+(row-1)*6).*exp(%i*%pi/180.0*Mat(i,5+(row-1)*6));
      s33(i) = Mat(i,6+(row-1)*6).*exp(%i*%pi/180.0*Mat(i,7+(row-1)*6));
      
    elseif ((n==3) & (FRMT$ == 'DB'))
    //  f   dB(s11) ph(s11) dB(s12) ph(s12) dB(s13) ph(s13) 
    //      dB(s21) ph(s21) dB(s22) ph(s22) dB(s23) ph(s23) 
    //      dB(s31) ph(s31) dB(s32) ph(s33) dB(s33) ph(s33)
      printf('S parameters: n=3 FRMT$=DB \n');
      f(i) = Mat(i,1).*Funit;
      row=1;
      s11(i) = 10.^(Mat(i,2+(row-1)*6)./20).*exp(%i*%pi/180.0*Mat(i,3+(row-1)*6));
      s12(i) = 10.^(Mat(i,4+(row-1)*6)./20).*exp(%i*%pi/180.0*Mat(i,5+(row-1)*6));
      s13(i) = 10.^(Mat(i,6+(row-1)*6)./20).*exp(%i*%pi/180.0*Mat(i,7+(row-1)*6));
      row=2;
      s21(i) = 10.^(Mat(i,2+(row-1)*6)./20).*exp(%i*%pi/180.0*Mat(i,3+(row-1)*6));
      s22(i) = 10.^(Mat(i,4+(row-1)*6)./20).*exp(%i*%pi/180.0*Mat(i,5+(row-1)*6));
      s23(i) = 10.^(Mat(i,6+(row-1)*6)./20).*exp(%i*%pi/180.0*Mat(i,7+(row-1)*6));
      row=3;
      s31(i) = 10.^(Mat(i,2+(row-1)*6)./20).*exp(%i*%pi/180.0*Mat(i,3+(row-1)*6));
      s32(i) = 10.^(Mat(i,4+(row-1)*6)./20).*exp(%i*%pi/180.0*Mat(i,5+(row-1)*6));
      s33(i) = 10.^(Mat(i,6+(row-1)*6)./20).*exp(%i*%pi/180.0*Mat(i,7+(row-1)*6));
      
    elseif ((n==4) & (FRMT$ == 'DB'))
    printf('S parameters: n=4 FRMT$=DB \n');  
    //  f   dB(s11) ph(s11) dB(s12) ph(s12) dB(s13) ph(s13) dB(s14) ph(s14) 
    //      dB(s21) ph(s21) dB(s22) ph(s22) dB(s23) ph(s23) dB(s24) ph(s24) 
    //      dB(s31) ph(s31) dB(s32) ph(s33) dB(s33) ph(s33) dB(s34) ph(s34) 
    //      dB(s41) ph(s41) dB(s42) ph(s42) dB(s43) ph(s43) dB(s44) ph(s44) 
      f(i) = Mat(i,1).*Funit;
      row = 1;
      s11(i) = 10.^(Mat(i,2+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,3+(row-1)*8));
      s12(i) = 10.^(Mat(i,4+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,5+(row-1)*8));
      s13(i) = 10.^(Mat(i,6+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,7+(row-1)*8));
      s14(i) = 10.^(Mat(i,8+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,9+(row-1)*8));
      row=2;
      s21(i) = 10.^(Mat(i,2+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,3+(row-1)*8));
      s22(i) = 10.^(Mat(i,4+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,5+(row-1)*8));
      s23(i) = 10.^(Mat(i,6+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,7+(row-1)*8));
      s24(i) = 10.^(Mat(i,8+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,9+(row-1)*8));
      row=3;
      s31(i) = 10.^(Mat(i,2+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,3+(row-1)*8));
      s32(i) = 10.^(Mat(i,4+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,5+(row-1)*8));
      s33(i) = 10.^(Mat(i,6+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,7+(row-1)*8));
      s34(i) = 10.^(Mat(i,8+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,9+(row-1)*8));
      row=4;
      s41(i) = 10.^(Mat(i,2+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,3+(row-1)*8));
      s42(i) = 10.^(Mat(i,4+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,5+(row-1)*8));
      s43(i) = 10.^(Mat(i,6+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,7+(row-1)*8));
      s44(i) = 10.^(Mat(i,8+(row-1)*8)./20).*exp(%i*%pi/180.0*Mat(i,9+(row-1)*8));

    elseif ((n==4) & (FRMT$ == 'MA'))
    printf('S parameters: n=4 FRMT$=MA \n');
    //  f   abs(s11) ph(s11) abs(s12) ph(s12) abs(s13) ph(s13) abs(s14) ph(s14) 
    //      abs(s21) ph(s21) abs(s22) ph(s22) abs(s23) ph(s23) abs(s24) ph(s24) 
    //      abs(s31) ph(s31) abs(s32) ph(s33) abs(s33) ph(s33) abs(s34) ph(s34) 
    //      abs(s41) ph(s41) abs(s42) ph(s42) abs(s43) ph(s43) abs(s44) ph(s44) 
      f(i) = Mat(i,1).*Funit;
      row=1;
      s11(i) = Mat(i,2+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,3+(row-1)*8));
      s12(i) = Mat(i,4+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,5+(row-1)*8));
      s13(i) = Mat(i,6+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,7+(row-1)*8));
      s14(i) = Mat(i,8+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,9+(row-1)*8));
      row=2;
      s21(i) = Mat(i,2+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,3+(row-1)*8));
      s22(i) = Mat(i,4+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,5+(row-1)*8));
      s23(i) = Mat(i,6+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,7+(row-1)*8));
      s24(i) = Mat(i,8+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,9+(row-1)*8));
      row=3;
      s31(i) = Mat(i,2+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,3+(row-1)*8));
      s32(i) = Mat(i,4+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,5+(row-1)*8));
      s33(i) = Mat(i,6+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,7+(row-1)*8));
      s34(i) = Mat(i,8+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,9+(row-1)*8));
      row=4;
      s41(i) = Mat(i,2+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,3+(row-1)*8));
      s42(i) = Mat(i,4+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,5+(row-1)*8));
      s43(i) = Mat(i,6+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,7+(row-1)*8));
      s44(i) = Mat(i,8+(row-1)*8).*exp(%i*%pi/180.0*Mat(i,9+(row-1)*8));

    elseif ((n==4) & (FRMT$ == 'RI'))
    printf('S parameters: n=4 FRMT$=RI \n');  
    // read file - format - one row 
    //  f   Re(s11) Im(s11) Re(s12) Im(s12) Re(s13) Im(s13) Re(s14) Im(s14) 
    //      Re(s21) Im(s21) Re(s22) Im(s22) Re(s23) Im(s23) Re(s24) Im(s24) 
    //      Re(s31) Im(s31) Re(s32) Im(s33) Re(s33) Im(s33) Re(s34) Im(s34) 
    //      Re(s41) Im(s41) Re(s42) Im(s42) Re(s43) Im(s43) Re(s44) Im(s44) 
      f(i) = Mat(i,1).*Funit;
      row = 1;
      s11(i) = Mat(i,2+(row-1)*8)+%i*Mat(i,3+(row-1)*8);
      s12(i) = Mat(i,4+(row-1)*8)+%i*Mat(i,5+(row-1)*8);
      s13(i) = Mat(i,6+(row-1)*8)+%i*Mat(i,7+(row-1)*8);
      s14(i) = Mat(i,8+(row-1)*8)+%i*Mat(i,9+(row-1)*8);
      row=2;
      s21(i) = Mat(i,2+(row-1)*8)+%i*Mat(i,3+(row-1)*8);
      s22(i) = Mat(i,4+(row-1)*8)+%i*Mat(i,5+(row-1)*8);
      s23(i) = Mat(i,6+(row-1)*8)+%i*Mat(i,7+(row-1)*8);
      s24(i) = Mat(i,8+(row-1)*8)+%i*Mat(i,9+(row-1)*8);
      row=3;
      s31(i) = Mat(i,2+(row-1)*8)+%i*Mat(i,3+(row-1)*8);
      s32(i) = Mat(i,4+(row-1)*8)+%i*Mat(i,5+(row-1)*8);
      s33(i) = Mat(i,6+(row-1)*8)+%i*Mat(i,7+(row-1)*8);
      s34(i) = Mat(i,8+(row-1)*8)+%i*Mat(i,9+(row-1)*8);
      row=4;
      s41(i) = Mat(i,2+(row-1)*8)+%i*Mat(i,3+(row-1)*8);
      s42(i) = Mat(i,4+(row-1)*8)+%i*Mat(i,5+(row-1)*8);
      s43(i) = Mat(i,6+(row-1)*8)+%i*Mat(i,7+(row-1)*8);
      s44(i) = Mat(i,8+(row-1)*8)+%i*Mat(i,9+(row-1)*8);
    else
      printf('S parameters n=%d F=%s \n', n, FRMT$);
      printf('not supported parameters !!! \n');
    end

    if (n==1) 
      S=hypermat([1,1,N]); // for loop seems to be necessary 
      for i=1:N
        S(:,:,i)=[s11(i)];
      end;  
    elseif (n==2) 
      S=hypermat([2,2,N]); // for loop seems to be necessary
      for i=1:N  
        S(:,:,i)=[s11(i), s12(i); s21(i), s22(i)];
      end;
    elseif (n==3)
      S=hypermat([3,3,N]); // for loop seems to be necessary
      for i=1:N 
        S(:,:,i)=[s11(i), s12(i), s13(i); 
                  s21(i), s22(i), s23(i); 
                  s31(i), s32(i), s33(i)];
       end           
    elseif (n==4)
      S=hypermat([4,4,N]); // for loop seems to be necessary
      for i=1:N 
        S(:,:,i)=[s11(i), s12(i), s13(i), s14(i);
                  s21(i), s22(i), s23(i), s24(i);
                  s31(i), s32(i), s33(i), s34(i);
                  s41(i), s42(i), s43(i), s44(i)];
      end            
    else            
      printf('not supported size n=%d \n', );
      printf('Unknown parameters !!! \n');
    end

    host('del /Q ' + temp_data$);

endfunction

