* NUTMEG for AMP lna1a
* THIS LINE IS IMPORTANT

.control      
 set file_name1="_r/lna1a"
 load $(file_name1).r1
 echo  file=$(file_name1)
 display

 set color0 = r255g255b255
 set color1 = r165g165b165
 set color2 = r255g000b000
 set color3 = r000g255b000
 set color4 = r000g000b255
 set color5 = r255g000b255

 unset plotwininfo
 set plotwinwidth = 500
 set plotwinheight = 500

* unity circle
 set units=degrees
 let N = length(frequency)
 let circ_ph=(vector(N)/N)*360
 let unity_circ=(cos(circ_ph),sin(circ_ph))

 let s11= K_Us11_V1
 let s21= K_Us21_V1
 let s22= K_Us22_V2
 let s12= K_Us12_V2

 plot create dB_plot
+ xlabel 'f[Hz]'
+ ylabel 'dB'
+ title  'R-dB(s11)|G-dB(s21)|B-dB(s22)|M-dB(s12)'

 plot append dB_plot db(s11) db(s21) db(s22) db(s12)


 plot create ph_plot xlog
+ xlabel 'f[Hz]'
+ ylabel 'ph'
+ title  'R-ph(s11)|G-ph(s21)|B-ph(s22)|M-ph(s12)'

 plot append ph_plot ph(s11) ph(s21) ph(s22) ph(s12)

 plot create SmithPlot mode cx smithz
+ title  'R-(s11)|B-(s22)'

 plot append SmithPlot aspect xlin xlimit -1.0 1.0  ylin ylimit -1.0 1.0  s11 unity_circ s22


.endc

.END
