// calc s-parameters for ideal coupler
clear;
clearglobal;
clc;
lines(0);
chdir(get_absolute_file_path('lna1a.sce'));
// ----------------------------------------------------------

exec("..\_sci\m0_scan_param1.sci");
exec("..\_sci\m0_data.sci");
// open and scan *.m0 file to get
m0$="_m\lna1a.m0";
[path,fname,extension]=fileparts(m0$)
// Number of PARAMS
PAR = 0;
parse_m0(m0$, PAR);

[f,s11] = tf_read(path+FN(find_dataname_indexes('K_Us11_V1'))); 
[f,s21] = tf_read(path+FN(find_dataname_indexes('K_Us21_V1')));
[f,s12] = tf_read(path+FN(find_dataname_indexes('K_Us12_V2'))); 
[f,s22] = tf_read(path+FN(find_dataname_indexes('K_Us22_V2')));

[s11dB,s11ph]=dbphi(s11);
[s21dB,s21ph]=dbphi(s21);
[s12dB,s12ph]=dbphi(s12);
[s22dB,s22ph]=dbphi(s22);

plot1_init();
plot1_tfdB(f,[s11dB,s21dB,s22dB,s12dB],['s11dB','s21dB','s22dB','s12dB'],[5,3,2,6]);

