// calc s-parameters for ideal coupler
clear;
clearglobal;
clc;
lines(0);
chdir(get_absolute_file_path('ex1.sce'));
xdel(winsid());

// toolbox
exec("..\..\_sci\m0_scan_param1.sci");
exec("..\..\_sci\m0_proc_data.sci");
exec("..\..\_sci\s_p_file.sci");

// reference s-parameter file
s_p_filename$="..\_s_p\m625633a.s2p";

// ----------------------------------------------------------
// open and scan *.m0 file to get TF
m0$="..\_m\lna1a.m0";
[path,fname,extension]=fileparts(m0$)
// Number of PARAMS
PAR = 0;
parse_m0(m0$, PAR);

[fa,s11a] = tf_read(path+FN(find_dataname_indexes('K_Us11_V1'))); 
[fa,s21a] = tf_read(path+FN(find_dataname_indexes('K_Us21_V1')));
[fa,s12a] = tf_read(path+FN(find_dataname_indexes('K_Us12_V2'))); 
[fa,s22a] = tf_read(path+FN(find_dataname_indexes('K_Us22_V2')));

[s11a_dB,s11a_ph]=dbphi(s11a);
[s21a_dB,s21a_ph]=dbphi(s21a);
[s12a_dB,s12a_ph]=dbphi(s12a);
[s22a_dB,s22a_ph]=dbphi(s22a);

h1=plot_init();
plot_tf(h1, fa,[s11a_dB,s21a_dB,s22a_dB,s12a_dB],['s11a_dB','s21a_dB','s22a_dB','s12a_dB'],[5,3,2,6]);
xtitle(m0$);

// ----------------------------------------------------------
// get the s-parameters file and compare
[f,S] = s_p_file(s_p_filename$);
N = max(size(f));
s11 = matrix(S(1,1,:),N,1);
s12 = matrix(S(1,2,:),N,1);
s21 = matrix(S(2,1,:),N,1);
s22 = matrix(S(2,2,:),N,1);

s11i = Cmplx_interpln(f,s11,fa);
s12i = Cmplx_interpln(f,s12,fa);
s21i = Cmplx_interpln(f,s21,fa);
s22i = Cmplx_interpln(f,s22,fa);

[s11i_dB,s11i_ph]=dbphi(s11i);
[s21i_dB,s21i_ph]=dbphi(s21i);
[s12i_dB,s12i_ph]=dbphi(s12i);
[s22i_dB,s22i_ph]=dbphi(s22i);

h2=plot_init();
plot_tf(h2, fa,[s11i_dB,s21i_dB,s22i_dB,s12i_dB],['s11i_dB','s21i_dB','s22i_dB','s12i_dB'],[5,3,2,6]);
xtitle(s_p_filename$);

