* Active splitter calculate s-parameters from voltage gain
* THIS LINE IS IMPORTANT

.control      
 set file_name1="_r/act_splt"
 load $(file_name1).r1
 echo  red-file=$(file_name1)
 display

 set plotwinwidth = 400
 set plotwinheight = 400

 unset plotwininfo

* unity circle
 set units=degrees
 let N = length(frequency)
 let circ_ph=(vector(N)/N)*360
 let unity_circ=(cos(circ_ph),sin(circ_ph))

* red, green, blue, magenta, yellow, cyan, black 
 set color0 = r255g255b255
 set color1 = r165g165b165
 set color2 = r255g000b000
 set color3 = r000g255b000
 set color4 = r000g000b255
 set color5 = r255g000b255
 set color6 = r255g255b000
 set color7 = r000g255b255
 set color8 = r000g000b000


 let eps=1.0E-15
  
 let s11=2*K_U1_V1-1
 let s21=2*K_U2_V1
 let s31=2*K_U3_V1
 let s41=2*K_U4_V1

 let s12=2*K_U1_V2
 let s22=2*K_U2_V2-1
 let s32=2*K_U3_V2
 let s42=2*K_U4_V2

 let s13=2*K_U1_V3
 let s23=2*K_U2_V3
 let s33=2*K_U3_V3-1
 let s43=2*K_U4_V3

 let s14=2*K_U1_V4
 let s24=2*K_U2_V4
 let s34=2*K_U3_V4
 let s44=2*K_U4_V4-1
 
 plot create sXX 
+ xlabel 'f[Hz]'
+ ylabel 'dB(s11)|dB(s22)|dB(s33)|dB(s44)|'
+ title  'R-s11|G-s22|B-s33|M-s44'
 plot append sXX ylimit -20 0  db(s11+eps) db(s22+eps) db(s33+eps) db(s44+eps)

 plot create SmithPlot mode cx smithz
+ title  'R-s11|B-s22|M-s33|Y-s44'
 plot append SmithPlot aspect xlin xlimit -1.0 1.0  ylin ylimit -1.0 1.0  s11 unity_circ s22 s33 s44


 plot create sX1 
+ xlabel 'f[Hz]'
+ ylabel 'dB(s21)|dB(s31)|dB(s41)'
+ title  'R-s21|G-s31|B-s41'
 plot append sX1 ylimit 0 5 db(s21+eps) db(s31+eps) db(s41+eps)

 plot create sXY 
+ xlabel 'f[Hz]'
+ ylabel 'dB(s42)|dB(s43)|dB(s24)|dB(s34)|'
+ title  'R-s42|G-s43|B-s24|M-s34|'
 plot append sXY  ylimit -40 0  db(s42+eps) db(s43+eps) db(s24+eps) db(s34+eps)

 plot create s1X 
+ xlabel 'f[Hz]'
+ ylabel 'dB(s12)|dB(s13)|dB(s14)'
+ title  'R-s12|G-s13|B-s14'
 plot append s1X  ylimit -40 0  db(s12+eps) db(s13+eps) db(s14+eps)


.endc

.END
