* Coupled transmission lines
* THIS LINE IS IMPORTANT

.control      
 set file_name1="_r/act_splt_param"
 load $(file_name1).r1
 load $(file_name1).r2
 load $(file_name1).r3
 load $(file_name1).r4
 load $(file_name1).r5
 load $(file_name1).r6
 display
 set plotwinwidth = 400
 set plotwinheight = 400

 unset plotwininfo

* unity circle
 set units=degrees
 let N = length(frequency)
 let circ_ph=(vector(N)/N)*360
 let unity_circ=(cos(circ_ph),sin(circ_ph))

* red, green, blue, magenta, yellow, cyan, black 
 set color0 = r255g255b255
 set color1 = r165g165b165
 set color2 = r255g000b000
 set color3 = r000g255b000
 set color4 = r000g000b255
 set color5 = r255g000b255
 set color6 = r255g255b000
 set color7 = r000g255b255
 set color8 = r000g000b000

 let eps=1.0E-15
  
 let ac1.s11=2*ac1.K_U1_V1-1
 let ac1.s41=2*ac1.K_U4_V1

 let ac2.s11=2*ac2.K_U1_V1-1
 let ac2.s41=2*ac2.K_U4_V1

 let ac3.s11=2*ac3.K_U1_V1-1
 let ac3.s41=2*ac3.K_U4_V1

 let ac4.s11=2*ac4.K_U1_V1-1
 let ac4.s41=2*ac4.K_U4_V1

 let ac5.s11=2*ac5.K_U1_V1-1
 let ac5.s41=2*ac5.K_U4_V1

 let ac6.s11=2*ac6.K_U1_V1-1
 let ac6.s41=2*ac6.K_U4_V1

 
 plot create s11dB_plot xlog ylimit -20 0
+ xlabel 'f[Hz]'
+ ylabel 'dB(s11)'
+ title  'dB(s11):R-ac1|G-ac2|B-ac3|M-ac4|Y-ac5|C-ac6'
 plot append s11dB_plot  db(ac1.s11+eps) db(ac2.s11+eps) db(ac3.s11+eps) db(ac4.s11+eps) db(ac5.s11+eps) db(ac6.s11+eps)
 
 plot create s41dB_plot xlog ylimit 0 3
+ xlabel 'f[Hz]'
+ ylabel 'dB(s41)'
+ title  'dB(s41):R-ac1|G-ac2|B-ac3|M-ac4|Y-ac5|C-ac6'
 plot append s41dB_plot  db(ac1.s41+eps) db(ac2.s41+eps) db(ac3.s41+eps) db(ac4.s41+eps) db(ac5.s41+eps) db(ac6.s41+eps)

 plot create Smith_plot mode cx smithz
+ title  's11: R-ac1|G-ac2|B-ac3|M-ac4|Y-ac5|C-ac6'
 plot append Smith_plot aspect xlin xlimit -1.0 1.0  ylin ylimit -1.0 1.0  ac1.s11 ac2.s11 ac3.s11 ac4.s11 ac5.s11 ac6.s11
 
 set color2 = r000g000b000
 plot append Smith_plot aspect xlin xlimit -1.0 1.0  ylin ylimit -1.0 1.0 unity_circ
.endc

.END
