// calc s-parameters for ideal coupler
clear;
clearglobal;
clc;
lines(0);
chdir(get_absolute_file_path('ex2.sce'));
xdel(winsid());

// toolbox
exec("..\..\_sci\m0_scan_param1.sci");
exec("..\..\_sci\m0_proc_data.sci");
exec("..\..\_sci\s_p_file.sci");

// reference s-parameter file
s_p_filename$="..\_s_p\MAAM8820.s4p";

// ----------------------------------------------------------
// open and scan *.m0 file to get TF
m0$="..\_m\act_splt.m0";
[path,fname,extension]=fileparts(m0$)
// Number of PARAMS
PAR = 0;
parse_m0(m0$, PAR);

[fa,KU1_V1] = tf_read(path+FN(find_dataname_indexes('K_U1_V1'))); 
[fa,KU2_V1] = tf_read(path+FN(find_dataname_indexes('K_U2_V1')));
[fa,KU3_V1] = tf_read(path+FN(find_dataname_indexes('K_U3_V1'))); 
[fa,KU4_V1] = tf_read(path+FN(find_dataname_indexes('K_U4_V1')));

[fa,KU1_V2] = tf_read(path+FN(find_dataname_indexes('K_U1_V2'))); 
[fa,KU2_V2] = tf_read(path+FN(find_dataname_indexes('K_U2_V2')));
[fa,KU3_V2] = tf_read(path+FN(find_dataname_indexes('K_U3_V2'))); 
[fa,KU4_V2] = tf_read(path+FN(find_dataname_indexes('K_U4_V2')));

[fa,KU1_V3] = tf_read(path+FN(find_dataname_indexes('K_U1_V3'))); 
[fa,KU2_V3] = tf_read(path+FN(find_dataname_indexes('K_U2_V3')));
[fa,KU3_V3] = tf_read(path+FN(find_dataname_indexes('K_U3_V3'))); 
[fa,KU4_V3] = tf_read(path+FN(find_dataname_indexes('K_U4_V3')));

[fa,KU1_V4] = tf_read(path+FN(find_dataname_indexes('K_U1_V4'))); 
[fa,KU2_V4] = tf_read(path+FN(find_dataname_indexes('K_U2_V4')));
[fa,KU3_V4] = tf_read(path+FN(find_dataname_indexes('K_U3_V4'))); 
[fa,KU4_V4] = tf_read(path+FN(find_dataname_indexes('K_U4_V4')));

s11a = 2*KU1_V1-1;
s21a = 2*KU2_V1;
s31a = 2*KU3_V1;
s41a = 2*KU4_V1;

s12a = 2*KU1_V2;
s22a = 2*KU2_V2-1;
s32a = 2*KU3_V2;
s42a = 2*KU4_V2;

s13a = 2*KU1_V3;
s23a = 2*KU2_V3;
s33a = 2*KU3_V3-1;
s43a = 2*KU4_V3;

s14a = 2*KU1_V4;
s24a = 2*KU2_V4;
s34a = 2*KU3_V4;
s44a = 2*KU4_V4-1;

[s11a_dB,s11a_ph]=dbphi(s11a);
[s22a_dB,s22a_ph]=dbphi(s22a);
[s33a_dB,s33a_ph]=dbphi(s33a);
[s44a_dB,s44a_ph]=dbphi(s44a);

[s21a_dB,s21a_ph]=dbphi(s21a);
[s31a_dB,s12a_ph]=dbphi(s31a);
[s41a_dB,s22a_ph]=dbphi(s41a);

// ----------------------------------------------------------
// get the s-parameters file to compare
[F,S] = s_p_file(s_p_filename$);
N = max(size(F));
s11 = matrix(S(1,1,:),N,1);
s12 = matrix(S(1,2,:),N,1);
s13 = matrix(S(1,3,:),N,1);
s14 = matrix(S(1,4,:),N,1);

s21 = matrix(S(2,1,:),N,1);
s22 = matrix(S(2,2,:),N,1);
s23 = matrix(S(2,3,:),N,1);
s24 = matrix(S(2,4,:),N,1);

s31 = matrix(S(3,1,:),N,1);
s32 = matrix(S(3,2,:),N,1);
s33 = matrix(S(3,3,:),N,1);
s34 = matrix(S(3,4,:),N,1);

s41 = matrix(S(4,1,:),N,1);
s42 = matrix(S(4,2,:),N,1);
s43 = matrix(S(4,3,:),N,1);
s44 = matrix(S(4,4,:),N,1);

// interpolate
s11i = Cmplx_interpln(F,s11,fa);
s22i = Cmplx_interpln(F,s22,fa);
s33i = Cmplx_interpln(F,s33,fa);
s44i = Cmplx_interpln(F,s44,fa);

s21i = Cmplx_interpln(F,s21,fa);
s31i = Cmplx_interpln(F,s31,fa);
s41i = Cmplx_interpln(F,s41,fa);

// convert
[s11i_dB,s11i_ph]=dbphi(s11i);
[s22i_dB,s22i_ph]=dbphi(s22i);
[s33i_dB,s33i_ph]=dbphi(s33i);
[s44i_dB,s44i_ph]=dbphi(s44i);

[s21i_dB,s21i_ph]=dbphi(s21i);
[s31i_dB,s12i_ph]=dbphi(s31i);
[s41i_dB,s22i_ph]=dbphi(s41i);

h1=plot_init();
plot_tf(h1, fa,[s21a_dB,s21i_dB],['s21a_dB','s21i_dB'],[5,3]);
xtitle(m0$ + '  vs  ' + s_p_filename$);

h2=plot_init();
plot_tf(h2, fa,[s31a_dB,s31i_dB],['s31a_dB','s31i_dB'],[5,3]);
xtitle(m0$ + '  vs  ' + s_p_filename$);

h3=plot_init();
plot_tf(h3, fa,[s11a_dB,s11i_dB],['s11a_dB','s11i_dB'],[5,3]);
xtitle(m0$ + '  vs  ' + s_p_filename$);

h4=plot_init();
plot_tf(h4, fa,[s22a_dB,s22i_dB],['s22a_dB','s22i_dB'],[5,3]);
xtitle(m0$ + '  vs  ' + s_p_filename$);

