
* red, green, blue, magenta, yellow, cyan, black 
 set color0 = r255g255b255
 set color1 = r165g165b165
 set color2 = r255g000b000
 set color3 = r000g255b000
 set color4 = r000g000b255
 set color5 = r255g000b255
 set color6 = r255g255b000
 set color7 = r000g255b255
 set color8 = r000g000b000

 unset plotwininfo

* unity circle
 let N = length(frequency)
 let cir_ph=(vector(N)/N)*2*pi
 let cir_X=cos(cir_ph)
 let cir_Y=sin(cir_ph)
 let unity_cir=(cir_X,cir_Y)

 *stability
 let delta = s11*s22-s21*s12
 let k = (1 - abs(s11)^2 - abs(s22)^2 + abs(delta)^2)/(2*abs(s12*s21)+eps)
 let B1 = (1 + abs(s11)^2 - abs(s22)^2 - abs(delta)^2)
 let u1 = (1 - abs(s22)^2)/(abs(s11-delta*(real(s22),-imag(s22))+abs(s21*s12))+eps)
 let u2 = (1 - abs(s11)^2)/(abs(s22-delta*(real(s11),-imag(s11))+abs(s21*s12))+eps)
 
* conjugate using operator (x,y)=x+jy
 let c_delta = (real(delta), -imag(delta))
 let c_s11 = (real(s11), -imag(s11))
 let c_s22 = (real(s22), -imag(s22))
* Stability circle for Load  CL-center, RL-radius
 let CL = (s11*c_delta-c_s22)/(abs(delta)^2-abs(s22)^2)
 let RL = abs((s21*s12)/(abs(delta)^2-abs(s22)^2))
* Distance of the circle from the point [0,0] - might be negative 
 let DL = abs(CL)-RL
* Stability circle for Source  CS-center, RS-radius
 let CS = (s22*c_delta-c_s11)/(abs(delta)^2-abs(s11)^2)
 let RS = abs((s21*s12)/(abs(delta)^2-abs(s11)^2))
* Distance of the circle from the point [0,0] - might be negative 
 let DS = abs(CS)-RS

* Sanity checks
* for centers of instability G_IN=S11(CL), G_OUT=S22(CS)
* could also be done for CL+/-RL CL+/-jRL 
* could also be done for CS+/-RS CS+/-jRS
 G_IN = s11 + (s12*s21*CL)/(1-s22*CL)
 G_OUT = s22 + (s12*s21*CS)/(1-s11*CS)
 set width = 500
 set nobreak = 1

 echo 'G_IN=S11(CL)'
 print real(frequency), CL, RL, DL, abs(G_IN)
 echo 'G_OUT=S22(CS)' 
 print real(frequency), CS, RS, DS, abs(G_OUT)

 plot create s11_s22_dB
+ xlabel 'f[Hz]'
+ ylabel 'dB(s11)|dB(s22)'
+ title  'R-dB(s11)|G-dB(s22)'

 plot append s11_s22_dB xlog db(s11+eps) db(s22+eps)
 
 plot create SmithPlot 
+ title  'R-(s11)|G-(s22)'

 plot append SmithPlot mode cx xlin ylin polar aspect xlimit -1.0 1.0 ylimit -1.0 1.0  s11 s22 
* black unity circle 
 set color2 = r000g000b000
 plot append SmithPlot mode cx xlin ylin polar aspect xlimit -1.0 1.0 ylimit -1.0 1.0 unity_cir
* recover red as color2
 set color2 = r255g000b000

 plot create s21_s12_dB
+ xlabel 'f[Hz]'
+ ylabel 'dB(s21)|dB(s12)'
+ title  'R-dB(s21)|G-dB(s12)'

 plot append s21_s12_dB xlog  db(s21+eps)  db(s12+eps)
 
 plot create k_B1 
+ xlabel 'f[Hz]'
+ ylabel 'k|B1'
+ title  'R-(k)|G-B1|B-1'

 plot append k_B1 xlog k B1 unitvec(frequency)  

 plot create DL_plot 
+ xlabel 'f[Hz]'
+ ylabel 'DL|CL|RL'
+ title  'R-(abs(CL))|G-(RL)|'

 plot append DL_plot xlog ylog abs(CL) RL unitvec(frequency)  

 
 plot create DS_plot 
+ xlabel 'f[Hz]'
+ ylabel 'DL|CL|RL'
+ title  'R-(abs(CS))|G-(RS)|'

 plot append DS_plot xlog ylog abs(CS) RS unitvec(frequency)  

.include .\nutmeg_stab_circ.nut
