// TunedQ1.aso
// Units
clear;
clc;
lines(0);
xdel(winsid());

chdir(get_absolute_file_path('Lmodel_f2.sce'));
// units definitions
exec('..\..\_sci\units_v1.sce');


Xoffset =100;
h_fig0=scf(0);    // create window 0
h_fig0.figure_position=[40+Xoffset,22];
h_fig0.figure_size=[650,650];
xbasc();

Xoffset =800;
h_fig1=scf(1);    // create window 1
h_fig1.figure_position=[40+Xoffset,22];
h_fig1.figure_size=[650,650];
xbasc();


// components
L=10*nH;
Fo=4000*MHz;
Q=22.6;

//f=frequencies 
fstep=10*MHz;
fstart=100*MHz;
fstop=10*GHz;

//---------------------
Wo=2*%pi*Fo;
C=1/Wo/Wo/L;
CpF=C/pF
R=Wo*L/Q

// TF
s=poly(0,'s');

// RLC.asi - RLC.mac
//  - - [C]- -
//  |         |
// -+-[R]-[L]-+-

Z=(R+s*L)/(s^2*L*C+s*R*C+1);
Zi=(s*L);
f=fstart:fstep:fstop;	
[z] =freq(numer(Z),denom(Z),(2*%pi*f*%i));
[zi] =freq(numer(Zi),denom(Zi),(2*%pi*f*%i));
m=abs(z);
phi=atan(imag(z),real(z))*180/%pi; // 2 argument atan!!!
mi=abs(zi);
phii=atan(imag(zi),real(zi))*180/%pi; // 2 argument atan!!!

[dbm,phi1]=dbphi(z);
[dbmi,phi2]=dbphi(zi);

scf(h_fig0);
subplot(2,1,1);
plot2d(f/MHz, dbm, style=2, logflag="ln");
plot2d(f/MHz, dbmi,style=5, logflag="ln");
xtitle('Module ZdB ', 'f', 'm');
xgrid();
subplot(2,1,2); 
plot2d(f/MHz, phi, style=2, logflag="ln");
plot2d(f/MHz, phii, style=5, logflag="ln");
xtitle('Phase deg', 'f', 'phi');
xgrid();

scf(h_fig1);
subplot(2,1,1);
plot2d(f/MHz, real(z), style=2);
plot2d(f/MHz, imag(z), style=5);
xtitle('z=r+jx', 'f', 'r,x');
xgrid();
subplot(2,1,2); 
plot2d(f/MHz, imag(z)./(real(z)+%eps), style=3);
xtitle('Q', 'f', 'q=x/r');
xgrid();
