// TunedQ1.aso
// Units
clear;
clc;
lines(0);
chdir(get_absolute_file_path('Lmodel_v1.sce'));
// units definitions
exec('..\..\_sci\units_v1.sce');
// components
L=680*nH
FQ_MOD = %F
if FQ_MOD
    Fo=4000*MHz;
    Q=150;
    Wo=2*%pi*Fo;
    R=Wo*L/Q
    C=1/Wo/Wo/L;
    CpF=C/pF
else
    Fo=520*MHz
    // freq for Q spec 
    Fq=100*MHz
    qf=35
    wq=2*%pi*Fq;
    Rq=wq*L/qf
    // increase of R due to skin effect 
    R=Rq*sqrt(Fo/Fq)
    Wo=2*%pi*Fo;
    C=1/Wo/Wo/L;
    CpF=C/pF
    Q=Wo*L/R
end;


