// TunedQ1.aso
// Units
clear;
clc;
lines(0);
xdel(winsid());

chdir(get_absolute_file_path('Rmodel_f1.sce'));
// units definitions
exec('..\..\_sci\units_v1.sce');


Xoffset =300;
h_fig0=scf(0);    // create window 0
h_fig0.figure_position=[40+Xoffset,22];
h_fig0.figure_size=[650,650];
xbasc();

// components
R=1000;
Fo=84*GHz;
Q=0.06;

//f=frequencies 
fstep=100*MHz;
fstart=1*MHz;
fstop=100*GHz;

//---------------------
Wo=2*%pi*Fo;
L=R*Q/Wo;
C=1/Wo/Wo/L;
CpF=C/pF
LnH=L/nH


// TF
s=poly(0,'s');
// RLC.asi - RLC.mac
//  - - [C]- -
//  |         |
// -+-[R]-[L]-+-

Z=(R+s*L)/(s^2*L*C+s*R*C+1);
Zi=R;
f=fstart:fstep:fstop;	
[tf] =freq(numer(Z),denom(Z),(2*%pi*f*%i));
[tfi] =freq(numer(Zi),denom(Zi),(2*%pi*f*%i));
m=abs(tf);
phi=atan(imag(tf),real(tf))*180/%pi; // 2 argument atan!!!
mi=abs(tfi);
phii=atan(imag(tfi),real(tfi))*180/%pi; // 2 argument atan!!!

[dbm,phi1]=dbphi(tf);
[dbmi,phi2]=dbphi(tfi);

scf(h_fig0);
subplot(2,1,1);
plot2d(f/MHz, dbm, style=2, logflag="ln");
plot2d(f/MHz, dbmi,style=5, logflag="ln");
xtitle('Module ZdB ', 'f', 'm');
xgrid();
subplot(2,1,2); 
plot2d(f/MHz, phi, style=2, logflag="ln");
plot2d(f/MHz, phii, style=5, logflag="ln");
xtitle('Phase deg', 'f', 'phi');
xgrid();

