// calc s1p parameters for s2p in series config
// s11 is GammaIn for GammaLoad=-1
// see maxima/s2_to_s1_series.mac
clear;
clearglobal;
clc;
lines(0);
chdir(get_absolute_file_path('s1p_vs_s1p.sce'));
xdel(winsid());

// toolbox
exec("..\..\_sci\s_p_file.sci");
exec("..\..\_sci\m0_proc_data.sci");

// input
s_p_filenameA$="..\_s_p\L10nH_series.s1p";
s_p_filenameB$="..\_s_p\L10nH_shunt.s1p";
// ----------------------------------------------------------
// get the s-parameters file to compare
[FA,S] = s_p_file(s_p_filenameA$);
N = max(size(FA));
s11A = matrix(S(1,1,:),N,1);

// ----------------------------------------------------------
// get the s-parameters file to compare
[FB,S] = s_p_file(s_p_filenameB$);
N = max(size(FB));
s11B = matrix(S(1,1,:),N,1);

h1=plot_init();
plot_tf(h1, FA,[real(s11A), imag(s11A)],['real(s11A)','imag(s11A)'],[5,3]);
xtitle(s_p_filenameA$);

h2=plot_init();
plot_tf(h2, FB,[real(s11B), imag(s11B)],['real(s11B)','imag(s11B)'],[5,3]);
xtitle(s_p_filenameB$);


