// calc s1p parameters for s2p in shunt config
// s11 is GammaIn for GammaLoad=1
// see maxima/s2_to_s1_shunt.mac
clear;
clearglobal;
clc;
lines(0);
chdir(get_absolute_file_path('s2p_shunt_to_s1p.sce'));

// input
s_p_filename$="..\_s_p\L680nH_shunt.s2p";
// output
s_filename$ = "..\_s_p\L680nH_shunt.s1p";
exec("..\..\_sci\s_param.sci");

// conversion
S11 = (s11.*s22 - s12.*s21 - s11)./(s22-1);

// output file operations
[fhnd, err]=mopen(s_filename$,"w")

mfprintf(fhnd,"!s1p created by s2p_shunt_to_s1p.sce \r\n");
mfprintf(fhnd,"!input: %s \r\n", s_p_filename$);
mfprintf(fhnd,"!output: %s \r\n", s_filename$);
mfprintf(fhnd,"#HZ S RI R %d \r\n", R0);
for i=1:N,  
  		mfprintf(fhnd,"%f  %f  %f \r\n", f(i), real(S11(i)), imag(S11(i)));
end;
mclose('all');

