// compare old and new version of loading s-parameter 
clear;
clearglobal;
clc;
lines(0);
chdir(get_absolute_file_path('s2p_vs_s2p.sce'));

// toolbox
exec("..\..\_sci\s_p_file.sci");
exec("..\..\_sci\m0_proc_data.sci");

// input
s_p_filename$="..\_s_p\L10nH_series.s2p";
exec("..\..\_sci\s_param.sci");
[s11_dB,s11a_ph]=dbphi(s11);
[s21_dB,s21a_ph]=dbphi(s21);
[s12_dB,s12a_ph]=dbphi(s12);
[s22_dB,s22a_ph]=dbphi(s22);

h1=plot_init();
plot_tf(h1, f,[s11_dB,s21_dB,s22_dB,s12_dB],['s11_dB','s21_dB','s22_dB','s12_dB'],[5,3,2,6]);
xtitle("..\..\_sci\s_param.sci");

// get the s-parameters file to compare
[F,S] = s_p_file(s_p_filename$);
N = max(size(F));
F=f;
N = max(size(F));
S11 = matrix(S(1,1,:),N,1);
S12 = matrix(S(1,2,:),N,1);
S21 = matrix(S(2,1,:),N,1);
S22 = matrix(S(2,2,:),N,1);

[S11_dB,S11a_ph]=dbphi(S11);
[S21_dB,S21a_ph]=dbphi(S21);
[S12_dB,S12a_ph]=dbphi(S12);
[S22_dB,S22a_ph]=dbphi(S22);

h2=plot_init();
plot_tf(h2, F,[S11_dB, S21_dB, S22_dB, S12_dB],['S11_dB','S21_dB','S22_dB','S12_dB'],[5,3,2,6]);
xtitle("..\..\_sci\s_p_file.sci");
