* Coupled transmission lines
* THIS LINE IS IMPORTANT

.control      
 set file_name1="cplt"
 load _r/$(file_name1).r1
 echo  red-file=$(file_name1)
 display

* red, green, blue, magenta, yellow, cyan, black 
 set color0 = r255g255b255
 set color1 = r165g165b165
 set color2 = r255g000b000
 set color3 = r000g255b000
 set color4 = r000g000b255
 set color5 = r255g000b255
 set color6 = r255g255b000
 set color7 = r000g255b255
 set color8 = r000g000b000

 unset plotwininfo

 set units=degrees
 let eps=1.0E-15
 
 let s11D=2*K_U1d_V1-1
 let s21D=2*K_U2d_V1

 let s11C=2*K_U1c_V2-1
 let s21C=2*K_U2c_V2

 let Zd = 105.0
 let Td=0.309E-9
 let Zc = 34.0
 let Tc=0.322E-9

 let Z0d=100
 let Z0c=25
 
 * theorethical differential s-param
 let omega=2*pi*frequency
 let phd=omega*Td
 let rod= (Zd-Z0d)/(Zd+Z0d)
 s11DT = rod*(1-exp(-i*2*phd))/(1-rod*rod*exp(-i*2*phd))
 s21DT = (1-rod*rod)*exp(-i*phd)/(1-rod*rod*exp(-i*2*phd))
 
 let phc=omega*Tc
 let roc= (Zc-Z0c)/(Zc+Z0c)
 s11CT = roc*(1-exp(-i*2*phc))/(1-roc*roc*exp(-i*2*phc))
 s21CT = (1-roc*roc)*exp(-i*phc)/(1-roc*roc*exp(-i*2*phc))

 plot create s11DdB_plot xlog
+ xlabel 'f[Hz]'
+ ylabel 'dB(s11D)|dB(s11DT)'
+ title  's11D(r)|s11DT(g)'

 plot append s11DdB_plot  db(s11D+eps) db(s11DT+eps)

 plot create s21DdB_plot xlog
+ xlabel 'f[Hz]'
+ ylabel 'dB(s21D)|dB(s21DT)'
+ title  's21D(r)|s21DT(g)'

 plot append s21DdB_plot  db(s21D+eps)  db(s21DT+eps)

 plot create s11CdB_plot xlog
+ xlabel 'f[Hz]'
+ ylabel 'dB(s11C)|dB(s11CT)'
+ title  's11C(r)|s11CT(g)'

 plot append s11CdB_plot  db(s11C+eps)  db(s11CT+eps)

 plot create s21CdB_plot xlog
+ xlabel 'f[Hz]'
+ ylabel 'dB(s21C)|dB(s21CT)'
+ title  's21C(r)|s21CT(g)'

 plot append s21CdB_plot  db(s21C+eps)  db(s21CT+eps)
 
.endc

.END
