//
// core part of calculations for NF example
// calling script defines global filenames 
// m0_filename$=".\_m\cas_nf_a.m0";
// LnaNoiFileName$=".\_s_p\b3410a.noi";
// TunerNoiFileName$=".\_s_p\b7125a.noi";
//

exec("..\_sci\m0_scan_param1.sci");
exec("..\_sci\m0_proc_data.sci");

function [f,TF] = ReadAmpTF(TFFileName$)

  // format: f[Hz], TF_re, TF_im 
  MatTF=read(TFFileName$,-1,3);
  [RTF,CTF]=size(MatTF);
  i=1:RTF;
  f(i)=MatTF(i,1);
  TF(i)=MatTF(i,2)+%i*MatTF(i,3);

endfunction  

function [f,NFmin,Yopt,RN] = ReadNoi(NoiFileName$,R0)
  
  // format: f[Hz], NFmin[dB], ABS(Gamma_opt), ARG(Gamma_opt), rn 
  MatNoi=read(NoiFileName$,-1,5);
  [N,K]=size(MatNoi)
  i=1:N;
  // get data
  f(i)=MatNoi(i,1);
  NFdB(i)=MatNoi(i,2);
  ModGo(i)=MatNoi(i,3);
  argGo(i)=MatNoi(i,4);
  rn(i) =MatNoi(i,5);
  // convert NF from dB
  NFmin(i)=10^(NFdB(i)/10);
  // Gamma to Yo=yo+jbo
  Gamma(i)=ModGo(i).*exp(%i*%pi*argGo(i)/180);
  z(i)=(1+Gamma(i))./(1-Gamma(i));
  Zopt(i)=R0*z(i);
  Yopt(i)=(1.0)./Zopt(i);
  RN(i)=rn(i)*R0;
endfunction

// Nonlinear equation set
// NFmin = 1 + (YN+RN*(yc+yo)^2)/yo; 
// yo = sqrt(yc^2+YN/RN)
// given: NFmin, RN, yo
// sought: YN,yc
function [y]=NFYo(x)
  // RN_x NFmin_x yo_x are global
  YN=x(1,1);
  yc=x(2,1);  
  F1=-NFmin_x+(YN+RN_x*(yc+yo_x)^2)/yo_x+1;
  F2=sqrt(yc^2+YN/RN_x)-yo_x;
  y=[F1;F2];
endfunction

// Jacobian for Nonlinear equation set
function [y]=NFYo_jacobian(x)
  // RN_x NFmin_x yo_x are global
  YN=x(1,1);
  yc=x(2,1);  
  dF1dx1 = 1/yo_x;
  dF1dx2 = 2*(yo_x+yc)*RN_x/yo_x;
  dF2dx1 = 1/(2*RN_x*sqrt(YN/RN_x+yc^2));
  dF2dx2 = yc/sqrt(YN/RN_x+yc^2);
  y=[dF1dx1, dF1dx2; dF2dx1, dF2dx2];
endfunction

function [Svv,Siin,Yc] = CalcNoiseParam(NFmin,Yopt,RN)
  for i=1:max(size(NFmin))
    NFmin_x = NFmin(i);
    RN_x = RN(i);
    yo_x = real(Yopt(i));
    bc(i,1)= - imag(Yopt(i));
  // NF(YN,yc), yo(YN,yc) is a nonlinear equation set
  // solved using Newton algorithm
  // inital estimation:
  // when sources are uncorrelated optimal source admitance is
  // Yopt=sqrt(YN/RN)  
  // starting estimate : find YN for yc=0 to have F2 = 0;
    YN0 =  RN_x * yo_x^2;
    [xres] = fsolve([YN0;0.00],NFYo,NFYo_jacobian);
    // check solution
    [zero] = NFYo(xres);
    // calculated YN
    YN(i,1)= xres(1,1);
    yc(i,1)= xres(2,1);
    Yc(i,1)= yc(i,1) + %i*bc(i,1); 
  end
  Svv = 4*kT*RN;
  Siin = 4*kT*YN;
endfunction

function X_i = InterpolateRealVar(X,fx,f_i);
  
  // reference matrix - must have 2 rows!, so Transpose
  Xref=[fx, X]';
  X_i=(interpln(Xref,f_i)).'; // nonConjugate transpose

endfunction

function Y_i = InterpolateComplexVar(Y,fy,f_i);
  
  // reference matrix - must have 2 rows! -  so Transpose
  Yre=[fy, real(Y)]';
  Yim=[fy, imag(Y)]';
  Yre_i=interpln(Yre,f_i);
  Yim_i=interpln(Yim,f_i);
  Y_i=(Yre_i+%i*Yim_i).'; // nonConjugate transpose

endfunction

function db = dB(TF) 
  // db = 20*log(TF)
  [db,phi]=dbphi(TF);
endfunction

function phi = ph(TF) 
  [db,phi]=dbphi(TF);
endfunction

function dbP = dBP(TF) 
  [db,phi]=dbphi(TF);
  // dbP = 10*log(TF)
  dbP=db/2;
endfunction

kT =  290*1.381E-23;
nV = 1.0E-9
nA = 1.0E-9
Rs = 75
MHz = 1.0E+6;
//format('e',15);
h_fig0=scf(0);    // create window 0
h_fig0.figure_position=[40,22];
h_fig0.figure_size=[650,600];
xbasc();
h=gcf();
toolbar(h.figure_id,'off');

// open and scan *.m0 file to get
// Number of PARAMS
PAR = 0;
[path,fname,extension]=fileparts(m0_filename$)
parse_m0(m0_filename$, PAR);

[f,K1] = tf_read(path+FN(find_dataname_indexes("K_Ut_V1"))); 
[fx,K2] = tf_read(path+FN(find_dataname_indexes("K_Ut_Vna")));
[fx,K3] = tf_read(path+FN(find_dataname_indexes("K_Ut_Vnt")));
[fx,M1] = tf_read(path+FN(find_dataname_indexes("M_Ut_Ina")));
[fx,M2] = tf_read(path+FN(find_dataname_indexes("M_Ut_Int")));

[f_a,NFmin_a,Yopt_a,RN_a] = ReadNoi(LnaNoiFileName$, 75);
[Svv_a,Siin_a,Yc_a] = CalcNoiseParam(NFmin_a,Yopt_a,RN_a);
Svv_lna = InterpolateRealVar(Svv_a, f_a, f);
Siin_lna = InterpolateRealVar(Siin_a, f_a, f);
Yc_lna = InterpolateComplexVar(Yc_a, f_a,f);


[f_t,NFmin_t,Yopt_t,RN_t] = ReadNoi(TunerNoiFileName$, 100);
[Svv_t,Siin_t,Yc_t] = CalcNoiseParam(NFmin_t,Yopt_t,RN_t);
Svv_tun = InterpolateRealVar(Svv_t, f_t, f);
Siin_tun = InterpolateRealVar(Siin_t, f_t, f);
Yc_tun = InterpolateComplexVar(Yc_t, f_t, f);

// source noise contribution
Svv_src = 4*kT*Rs;
So_src = Svv_src*abs(K1).^2;
// lna noise contribution
So_lna_i = Siin_lna.*(abs(M1).^2); 
So_lna_v = Svv_lna.*(abs(K2).^2);
So_lna_c = Svv_lna.*((abs(M1).^2).*(abs(Yc_lna).^2)+2*real(Yc_lna.*M1.*conj(K2)));
So_lna = So_lna_i+So_lna_v+So_lna_c;
// tuner noise contribution
So_tun_i = Siin_tun.*(abs(M2).^2);
So_tun_v = Svv_tun.*(abs(K3).^2);
So_tun_c = Svv_tun.*((abs(M2).^2).*(abs(Yc_tun).^2)+2*real(Yc_tun.*M2.*conj(K3)));
So_tun = So_tun_i + So_tun_v + So_tun_c;
NF=(So_src+So_lna+So_tun)./So_src;

NFdB = 10*log10(NF);

scf(h_fig0);

subplot(3,1,1);
plot2d(f/MHz, dBP(1+So_lna./So_src), style=5);
plot2d(f/MHz, dBP(1+So_lna_i./So_src), style=2);
plot2d(f/MHz, dBP(1+So_lna_v./So_src), style=3);
plot2d(f/MHz, dBP(1+So_lna_c./So_src), style=4);
xgrid();
xtitle("dBP(1+So_lna./So_src)");
legend(["lna","lna_i", "lna_v", "lna_c"],3);
subplot(3,1,2);
plot2d(f/MHz, dBP(1+So_tun./So_src), style=5);
plot2d(f/MHz, dBP(1+So_tun_i./So_src), style=2);
plot2d(f/MHz, dBP(1+So_tun_v./So_src), style=3);
plot2d(f/MHz, dBP(1+So_tun_c./So_src), style=4);
legend(["tun","tun_i", "tun_v", "tun_c"],3);
xgrid();
xtitle("dBP(1+So_tun./So_src)");
subplot(3,1,3);
plot2d(f/MHz, abs(NFdB), style=5);
xtitle("NF=dB(1+(So_tun+S_lna)./So_src)");

xgrid();
