// preferred number optimisation of a low pass filter
// Caps with $MOD FQ MODCx 
// C1..C4
// Inductors with $MOD FQ MODLx
// L1..L3

clear;
clearglobal;
clc;
lines(0);
chdir(get_absolute_file_path('pref_numb.sce'));
exec("..\_sci\p_numbers.sci");

// ----------------------------------------------------------
// ----------------------------------------------------------
// ----------------------------------------------------------
// Error Function TYPE - 
// PS_MAX - error = max (Pass Band) + max (Stop Band)  
// PS_SUM - error = sum (Pass Band) + sum (Stop Band)
// PTS_MAX - error =  max (Pass Band) + max (Trans Band) + max (Stop Band)  
// PTS_SUM - error = sum (Pass Band) + sum(Trans Band)+ sum (Stop Band)

ERR_FUNC_TYPE = 'PS_MAX'
FQ_MOD = 'HIGH_Q'

path$ = "\jobs\Amp\ex\ex6\pn_ps_max_le12_ce12\"

proj$  = "flp_hq_1G0_7th.in"
inc$   = "flp_hq_1G0_7th.inc"
ref$   = "flp_hq_1G0_7th_ref.in"
ideal$ = "flp_ch_1dB_1G0_7th_ideal.in"

// number of capacitors
NC=4;
// number of inductors
NL=3;
// preffered numbers
// C E24 10%
C_E=E12;
// L E12 10%
L_E=E12;

// PARAMETERS OF THE OPTIMISATION RUN
// log_version
logver$ = "1";
// low pass end frequency
LP_FREQ = 1.0E+9;
// low pass ripples
PB_Ripples_dB = 1.0;
// stop frequency
ST_FREQ=2.4E+9;
// stop attenuation
ST_Att_dB = -80;
// transition frequency start
TB_FREQ = 1.5E+9;
// transition attenuation start
TB_Att_dB = -40;
// initial exploratory step for Caps and Ind
dX = 0.10;
// minimal exploratory step for Caps and Ind
dX_min = 0.001;
// max amp calls
opt_run_max = 150;
// Pass_Band Error weight
PB_Weight = 1.0;
// Transition_Band Error weight
TB_Weight = 1.0;
// Stop_Band Error weight
SB_Weight = 1.0;
// Pattern search gain
PS_Gain = 1.0;


// error functions
select ERR_FUNC_TYPE 
case 'PS_MAX'
    logpath$="_log_ps_max\";
    exec("..\_sci\opt_err_ps_max.sci");
case 'PS_SUM'
    logpath$="_log_ps_sum\";
    exec("..\_sci\opt_err_ps_sum.sci");
case 'PTS_MAX'
    logpath$="_log_pts_max\";
    exec("..\_sci\opt_err_pts_max.sci");
case 'PTS_SUM'
    logpath$="_log_pts_sum\";
    exec("..\_sci\opt_err_pts_sum.sci");
else
    error('UNKNOWN_ERROR_FUNCTION_TYPE');
end  

// error functions
select FQ_MOD   
case 'HIGH_Q'
  exec("..\_sci\fq_C_L_hq_models.sci");
case 'LOW_Q'
  exec("..\_sci\fq_C_L_lq_models.sci");
else
    error('UNKNOWN_MOD_TYPE');
end  

// ----------------------------------------------------------
// open and scan *.m0 file to get
// global Tmajor Tmidlle Tminor Tname FN DN FD PN PV
// global XN XV
// global T FN DN FD PN PV
// DN - DATANAME, FN-FILENAME
// PN - PARAM_NAME, PV - PARAM_VALUE

// Number of PARAMS
PAR = 0;
exec("..\_sci\m0_scan_param1.sci");
exec("..\_sci\m0_data.sci");

amp$ = "\jobs\Amp\exe\Amp.exe"


if ~isdir(logpath$) then 
  mkdir(logpath$) 
end; 

// extract file_name for reference project
[x_path,p_fname_ref,p_ext]=fileparts(ref$);
// extract file_name for project
[x_path,p_fname,p_ext]=fileparts(proj$);
m0$=path$+"_m\"+p_fname+".m0";
[m_path,m_fname,m_extension]=fileparts(m0$);
log$=logpath$+p_fname+"_"+logver$+".log";


log_fhd=mopen(log$,'w');
mfprintf(log_fhd,"log:%s \n", log$);
mfprintf(log_fhd,"ERR_FUNC_TYPE = %s \n', ERR_FUNC_TYPE);
mfprintf(log_fhd,"FQ_MOD = %s \n', FQ_MOD);
mfprintf(log_fhd,"ref:%s \n", ref$);
mfprintf(log_fhd,"proj:%s \n", proj$);
mfprintf(log_fhd,"path: %s \n", path$);
mfprintf(log_fhd,"LP_FREQ = %f \n", LP_FREQ);
mfprintf(log_fhd,"PB_Ripples_dB = %f \n", PB_Ripples_dB);
mfprintf(log_fhd,"TB_FREQ = %f \n", TB_FREQ);
mfprintf(log_fhd,"TB_Att_dB = %f \n", TB_Att_dB);
mfprintf(log_fhd,"ST_FREQ = %f \n", ST_FREQ);
mfprintf(log_fhd,"ST_Att_dB = %f \n", ST_Att_dB);
mfprintf(log_fhd,"opt_run_max = %d \n", opt_run_max);
mfprintf(log_fhd,"dX = %f \n", dX);
mfprintf(log_fhd,"PB_Weight = %f \n", PB_Weight);
mfprintf(log_fhd,"SB_Weight = %f \n", SB_Weight);
mfprintf(log_fhd,"PS_Gain = %f \n", PS_Gain);
mfprintf(log_fhd,"elements in C_E = %d \n", length(C_E));
mfprintf(log_fhd,"elements in L_E = %d \n", length(L_E));

function set_inc(path$, inc$)
  
  inc_fhd=mopen(path$+inc$,'w');
  mfprintf(inc_fhd,"%s\n","* set by scicoslab");
  mfprintf(log_fhd,"%s\n","* set by scicoslab");
  // get FQ models for L
  [FL,QL]= FQ_L_Models(LV);
  // get FQ models for C
  [FC,QC]= FQ_C_Models(CV);
  
  for n=1:NC // must be a column vector  
    mfprintf(inc_fhd,"$MOD FQ M%s %G %G\n", CN(n), FC(n), QC(n));
    mfprintf(inc_fhd,"$LET %s %G \n", CN(n), CV(n));
    mfprintf(log_fhd,"$MOD FQ M%s %G %G\n", CN(n), FC(n), QC(n));
    mfprintf(log_fhd,"$LET %s %G \n", CN(n), CV(n));
  end
  for n=1:NL // must be a column vector  
    mfprintf(inc_fhd,"$MOD FQ M%s %G %G\n", LN(n), FL(n), QL(n));
    mfprintf(inc_fhd,"$LET %s %G \n", LN(n), LV(n));
    mfprintf(log_fhd,"$MOD FQ M%s %G %G\n", LN(n), FL(n), QL(n));
    mfprintf(log_fhd,"$LET %s %G \n", LN(n), LV(n));
  end
  
  mfprintf(log_fhd,"%s\n","******");
  mclose(inc_fhd);
endfunction

function [f, KU2, s21_dB] = run_amp(path$, input$)

  [p$,f_n$,ext$]=fileparts(input$);
  f_m0$=path$+"_m\"+f_n$+".m0";
  amp_err = run(amp$, path$, input$);
  parse_m0(f_m0$, PAR);
  [f,KU2] = tf_read(m_path+FN(find_dataname_indexes('K_U2_V1'))); 
  [KU2_dB,phiX] = dbphi(KU2);
  s21_dB = KU2_dB + 20*log10(2);// s21=2*KU2  

endfunction

function err_dB = evaluate_err(f,s21dB)        
    pass_err_dB = PB_aprox_err_dB(f,s21dB);
    tran_err_dB = TB_aprox_err_dB(f,s21dB);
    stop_err_dB = SB_aprox_err_dB(f,s21dB);  
    err_dB = pass_err_dB + tran_err_dB +stop_err_dB;
    mfprintf(log_fhd,"err_dB = %f pass_err_dB =%f tran_err_dB=%f stop_err_dB=%f  \n", err_dB, pass_err_dB, tran_err_dB, stop_err_dB);
endfunction





// ideal
mfprintf(log_fhd,"* ideal run \n");
[f, KU2_id, s21dB_id] = run_amp(path$, ideal$);
err_dB_id = evaluate_err(f,s21dB_id)

// refrence 
mfprintf(log_fhd,"* reference run \n");
[f, KU2_ref, s21dB_ref] = run_amp(path$, ref$);
err_dB_ref = evaluate_err(f,s21dB_ref)

plot1_init();
plot1_tfdB(f,[s21dB_id, s21dB_ref],['s21dB_id', 's21dB_ref'],[3,2]);

// parse names and values in ref file 
v1$=path$+"_m\"+p_fname_ref+".v1";
parse_vx(v1$);

// find indexes of C1..C4
ci=[];
for n=1:NC
 ci(n) = find(XN == 'C'+string(n));
end 

// find indexes of L1..L3
li=[];
for n=1:NL
 li(n) = find(XN == 'L'+string(n));
end 

// store original names and values
CN = XN(ci);
CV = XV(ci);
LV = XV(li);
LN = XN(li);
LV_0 = LV;
CV_0 = CV;

CV_OPT=zeros(NC,1);
CV_LT=zeros(NC,1);
CV_GT=zeros(NC,1);

LV_OPT=zeros(NL,1);
LV_LT=zeros(NL,1);
LV_GT=zeros(NL,1);

for n=1:NC
  [CV_CLOSEST(n),CV_LT(n),CV_GT(n)] =pref_numb(CV_0(n),C_E);
end;

for n=1:NL
  [LV_CLOSEST(n),LV_LT(n),LV_GT(n)] =pref_numb(LV_0(n),L_E);
end;

// start with closest
CV_0 = CV_CLOSEST;
LV_0 = LV_CLOSEST;
CV = CV_0
LV = LV_0 
// initial run, should be close to reference run
mfprintf(log_fhd,"* initial run \n");
set_inc(path$, inc$);
[f, KU2_ini, s21dB_ini] = run_amp(path$, proj$);
err_dB_min = evaluate_err(f,s21dB_ini)
plot2d(f/MHz, s21dB_ini, style=5);
p=get("hdl");
p.children.line_style=3;



 
for C_code=0:(2^NC)-1
  C_bits = bitvect8(C_code); // 1:NC bits
  for n=1:NC
    if C_bits(n) == 0
      CV(n) = CV_LT(n); // select PN less than for 0
    else
      CV(n) = CV_GT(n); // select PN greater than for 1
    end
  end
  for L_code=0:(2^NL)-1
    L_bits = bitvect8(L_code); // 1:NL bits   
    for n=1:NL
      if L_bits(n) == 0
        LV(n) = LV_LT(n); // select PN less than for 0
      else
        LV(n) = LV_GT(n); // select PN greater than for 1
      end
    end
    set_inc(path$, inc$);
    [f, KU2, s21dB] = run_amp(path$, proj$);
    err_dB = evaluate_err(f,s21dB);
    if err_dB < err_dB_min
      CV_0 = CV
      LV_0 = LV
      plot2d(f/MHz, s21dB, style=5);
      p=get("hdl");
      p.children.line_style=3;
      mfprintf(log_fhd,"* preferred number set successful C_code =%d, L_code = %d: err_dB_min = %f \n", C_code, L_code, err_dB_min);
    else
      plot2d(f/MHz, s21dB, style=2);
      p=get("hdl");
      p.children.line_style=3;
      mfprintf(log_fhd,"* preferred number set failed C_code =%d, L_code = %d: err_dB =%f, err_dB_min = %f \n", C_code, L_code, err_dB, err_dB_min);    
    end
  end;
end;



CV = CV_0
LV = LV_0
set_inc(path$, inc$);
[f, KU2, s21dB] = run_amp(path$, proj$);
err_dB = evaluate_err(f,s21dB);
plot2d(f/MHz, s21dB, style=5);
p=get("hdl");
p.children.line_style = 1; // solid
p.children.foreground = 5; // red
p.children.thickness = 2; //thick

mfprintf(log_fhd,"* This is the best result\n err_dB = %f \n", err_dB);
printf("* This is the best result\n err_dB = %f \n", err_dB);
mfprintf(log_fhd,"* That is all, folks\n");
printf("That is all, folks\n");
mclose('all');


