// optimisation of a filter
// Hooke-Jeeves Pattern Search with relative change of params
// sensitivities used in exploration
//*********************
// TO BE INVOKED BY MASTER SCRIPT
//*********************

// error functions
select ERR_FUNC_TYPE 
case 'PS_MAX'
    logpath$="_log_ps_max\";
    exec("..\..\..\_sci\opt_err_ps_max.sci");
case 'PS_SUM'
    logpath$="_log_ps_sum\";
    exec("..\..\..\_sci\opt_err_ps_sum.sci");
case 'PTS_MAX'
    logpath$="_log_pts_max\";
    exec("..\..\..\_sci\opt_err_pts_max.sci");
case 'PTS_SUM'
    logpath$="_log_pts_sum\";
    exec("..\..\..\_sci\opt_err_pts_sum.sci");
else
    error('UNKNOWN_ERROR_FUNCTION_TYPE');
end  

// error functions
select FQ_MOD   
case 'HIGH_Q'
  exec("..\..\..\_sci\fq_C_L_hq_models.sci");
case 'LOW_Q'
  exec("..\..\..\_sci\fq_C_L_lq_models.sci");
else
    error('UNKNOWN_MOD_TYPE');
end  

// ----------------------------------------------------------
// open and scan *.m0 file to get
// global Tmajor Tmidlle Tminor Tname FN DN FD PN PV
// global XN XV
// global T FN DN FD PN PV
// DN - DATANAME, FN-FILENAME
// PN - PARAM_NAME, PV - PARAM_VALUE
// Number of PARAMS

PAR = 0;
exec("..\..\..\_sci\m0_scan_param1.sci");
exec("..\..\..\_sci\m0_data.sci");

amp$ = "\jobs\Amp\exe\Amp.exe"


if ~isdir(logpath$) then 
  mkdir(logpath$) 
end; 

// extract file_name for reference project
[x_path,p_fname_ref,p_ext]=fileparts(ref$);
// extract file_name for project
[x_path,p_fname,p_ext]=fileparts(proj$);
m0$=path$+"_m\"+p_fname+".m0";
[m_path,m_fname,m_extension]=fileparts(m0$);
log$=logpath$+p_fname+"_"+logver$+".log";


log_fhd=mopen(log$,'w');
mfprintf(log_fhd,"log:%s \n", log$);
mfprintf(log_fhd,"ERR_FUNC_TYPE = %s \n', ERR_FUNC_TYPE);
mfprintf(log_fhd,"FQ_MOD = %s \n', FQ_MOD);
mfprintf(log_fhd,"ref:%s \n", ref$);
mfprintf(log_fhd,"proj:%s \n", proj$);
mfprintf(log_fhd,"path: %s \n", path$);
mfprintf(log_fhd,"LP_FREQ = %f \n", LP_FREQ);
mfprintf(log_fhd,"PB_Ripples_dB = %f \n", PB_Ripples_dB);
mfprintf(log_fhd,"TB_FREQ = %f \n", TB_FREQ);
mfprintf(log_fhd,"TB_Att_dB = %f \n", TB_Att_dB);
mfprintf(log_fhd,"ST_FREQ = %f \n", ST_FREQ);
mfprintf(log_fhd,"ST_Att_dB = %f \n", ST_Att_dB);
mfprintf(log_fhd,"opt_run_max = %d \n", opt_run_max);
mfprintf(log_fhd,"dX = %f \n", dX);
mfprintf(log_fhd,"PB_Weight = %f \n", PB_Weight);
mfprintf(log_fhd,"SB_Weight = %f \n", SB_Weight);
mfprintf(log_fhd,"PS_Gain = %f \n", PS_Gain);

function set_inc(path$, inc$)
  
  inc_fhd=mopen(path$+inc$,'w');
  mfprintf(inc_fhd,"%s\n","* set by scicoslab");
  mfprintf(log_fhd,"%s\n","* set by scicoslab");
  // get FQ models for L
  [FL,QL]= FQ_L_Models(LV);
  // get FQ models for C
  [FC,QC]= FQ_C_Models(CV);
  
  for n=1:NC // must be a column vector  
    mfprintf(inc_fhd,"$MOD FQ M%s %G %G\n", CN(n), FC(n), QC(n));
    mfprintf(inc_fhd,"$LET %s %G \n", CN(n), CV(n));
    mfprintf(log_fhd,"$MOD FQ M%s %G %G\n", CN(n), FC(n), QC(n));
    mfprintf(log_fhd,"$LET %s %G \n", CN(n), CV(n));
  end
  for n=1:NL // must be a column vector  
    mfprintf(inc_fhd,"$MOD FQ M%s %G %G\n", LN(n), FL(n), QL(n));
    mfprintf(inc_fhd,"$LET %s %G \n", LN(n), LV(n));
    mfprintf(log_fhd,"$MOD FQ M%s %G %G\n", LN(n), FL(n), QL(n));
    mfprintf(log_fhd,"$LET %s %G \n", LN(n), LV(n));
  end
  
  mfprintf(log_fhd,"%s\n","******");
  mclose(inc_fhd);
endfunction

function [f, KU2, s21_dB] = run_amp(path$, input$)

  [p$,f_n$,ext$]=fileparts(input$);
  f_m0$=path$+"_m\"+f_n$+".m0";
  amp_err = run(amp$, path$, input$);
  parse_m0(f_m0$, PAR);
  [f,KU2] = tf_read(m_path+FN(find_dataname_indexes('K_U2_V1'))); 
  [KU2_dB,phiX] = dbphi(KU2);
  s21_dB = KU2_dB + 20*log10(2);// s21=2*KU2  

endfunction

function err_dB = evaluate_err(f,s21dB)        
    pass_err_dB = PB_aprox_err_dB(f,s21dB);
    tran_err_dB = TB_aprox_err_dB(f,s21dB);
    stop_err_dB = SB_aprox_err_dB(f,s21dB);  
    err_dB = pass_err_dB + tran_err_dB +stop_err_dB;
    mfprintf(log_fhd,"err_dB = %f pass_err_dB =%f tran_err_dB=%f stop_err_dB=%f  \n", err_dB, pass_err_dB, tran_err_dB, stop_err_dB);
endfunction

function deltaKU = calc_deltaK(sens$)
     // read sensitivity
    [f,S_KU] = tf_read(m_path+FN(sens$));
    // calc relative delta using sensitivities and current dX
    deltaKU = real(S_KU).*dX;
    // saturate relative delta, so that there is no problems with logarithm of negative numbers 
    deltaKU( deltaKU >= 1.0) = 0.999;
    deltaKU( deltaKU <= -1.0) = -0.999;
endfunction

function s21dB = calc_s21dB(T,dT)
    KU=abs(T).*(1+dT);
    [KUdB,phiX] = dbphi(KU);
    s21dB = KUdB + 20*log10(2); // s21=2*KU  
endfunction

function vectors = explore_C()
// explore directions
// assume zero change
  vectors = zeros(NC);
  for n=1:NC 
    deltaKU2 = calc_deltaK(sens_c(n));
    mfprintf(log_fhd,"* explore +delta = %f for %s \n", dX, CN(n));
    // +delta search for n-th base
    s21dB = calc_s21dB(KU2, deltaKU2);
    err_dB_p = evaluate_err(f,s21dB);
    // -delta search for n-th base
    mfprintf(log_fhd,"* explore -delta = %f for %s \n", dX, CN(n));    
    s21dB = calc_s21dB(KU2, -deltaKU2);
    err_dB_m = evaluate_err(f,s21dB);
    if (err_dB_p < err_dB_min) & (err_dB_m < err_dB_min)  then // both directions gives smaller error
      if  (err_dB_p  <= err_dB_m) then                          // select bigger improvment
        vectors(n) = 1;
      else
        vectors(n) = -1;
      end 
    elseif (err_dB_p < err_dB_min) then // only +d gives smaller error
      vectors(n) = 1;
    elseif (err_dB_m < err_dB_min) then // only -d gives smaller error
      vectors(n) = -1; 
    else
      vectors(n) = 0; // no improvment - 0 remains  
    end
    mfprintf(log_fhd,"vector(%d) = %d  \n", n, vectors(n));
  end    
endfunction  

function vectors = explore_L()
// explore directions
// assume zero change
  vectors = zeros(NL);
  for n=1:NL 
    deltaKU2 = calc_deltaK(sens_l(n));
    mfprintf(log_fhd,"* explore +delta = %f for %s \n", dX, LN(n));
    // +delta search for n-th base
    s21dB = calc_s21dB(KU2, deltaKU2);
    err_dB_p = evaluate_err(f,s21dB);
    // -delta search for n-th base
    mfprintf(log_fhd,"* explore -delta = %f for %s \n", dX, LN(n));    
    s21dB = calc_s21dB(KU2, -deltaKU2);
    err_dB_m = evaluate_err(f,s21dB);
    if (err_dB_p < err_dB_min) & (err_dB_m < err_dB_min)  then // both directions gives smaller error
      if  (err_dB_p  <= err_dB_m) then                          // select bigger improvment
        vectors(n) = 1;
      else
        vectors(n) = -1;
      end 
    elseif (err_dB_p < err_dB_min) then // only +d gives smaller error
      vectors(n) = 1;
    elseif (err_dB_m < err_dB_min) then // only -d gives smaller error
      vectors(n) = -1; 
    else
      vectors(n) = 0; // no improvment - 0 remains  
    end
    mfprintf(log_fhd,"vector(%d) = %d  \n", n, vectors(n));
  end    
endfunction  


// reference project
mfprintf(log_fhd,"* ideal run \n");
[f, KU2_id, s21dB_id] = run_amp(path$, ideal$);
err_dB_id = evaluate_err(f,s21dB_id)


// refrence run
mfprintf(log_fhd,"* reference run \n");
[f, KU2_ref, s21dB_ref] = run_amp(path$, ref$);
err_dB_ref = evaluate_err(f,s21dB_ref)

plot1_init();
plot1_tfdB(f,[s21dB_id, s21dB_ref],['s21dB_id', 's21dB_ref'],[3,2]);

// parse names and values in ref file 
v1$=path$+"_m\"+p_fname_ref+".v1";
parse_vx(v1$);

// find indexes of C1..C4
ci=[];
for n=1:NC
 ci(n) = find(XN == 'C'+string(n));
 sens_c(n) = find_dataname_indexes('S_K_U2_V1_C'+string(n));
end 

// find indexes of L1..L3
li=[];
for n=1:NL
 li(n) = find(XN == 'L'+string(n));
 sens_l(n) = find_dataname_indexes('S_K_U2_V1_L'+string(n));
end 

// store original names and values
CN = XN(ci);
CV = XV(ci);
LV = XV(li);
LN = XN(li);
LV_0 = LV;
CV_0 = CV;

// initial run, should be close to reference run
mfprintf(log_fhd,"* initial run \n");
set_inc(path$, inc$);
[f, KU2_ini, s21dB_ini] = run_amp(path$, proj$);
err_dB_min = evaluate_err(f,s21dB_ini)
plot2d(f/MHz, s21dB_ini, style=5);
p=get("hdl");
p.children.line_style=3;
KU2=KU2_ini;

opt_run = 0;
pattern_search_step = 0;
//vectors elements are (+1,0,-1)
vectors_C = zeros(NC);
vectors_L = zeros(NL);

while (( dX > dX_min ) & (opt_run < opt_run_max) & (err_dB_min > 0))
  
  found_flag = 0;
  if (opt_run > 0) then
    // try pattern move - 2*delta - vectors elements are (+1,0,-1)       
    CV= CV_0.*(1+PS_Gain*2.0*dX.*vectors_C);
    LV= LV_0.*(1+PS_Gain*2.0*dX.*vectors_L);
    mfprintf(log_fhd,"* pattern search for run = %d \n", opt_run);
    set_inc(path$, inc$);
    [f, KU2, s21dB] = run_amp(path$, proj$);
    err_dB = evaluate_err(f,s21dB);
    if err_dB < err_dB_min then
      CV_0 = CV
      LV_0 = LV
      err_dB_min = err_dB
      found_flag = 1;
      pattern_search_step = pattern_search_step + 1;
      plot2d(f/MHz, s21dB, style=5);
      p=get("hdl");
      p.children.line_style=3;
      mfprintf(log_fhd,"* pattern_search_step = %d successful - err_dB_min = %f  \n", pattern_search_step, err_dB_min);      
    else
      plot2d(f/MHz, s21dB, style=2);
      p=get("hdl");
      p.children.line_style=3;
      // need to recover sensitivities from last valid point
      CV= CV_0;
      LV= LV_0;
      opt_run = opt_run + 1;
      mfprintf(log_fhd,"* base recovery opt_run = %d \n", opt_run);
      set_inc(path$, inc$);
      [f, KU2, s21dB] = run_amp(path$, proj$);
      err_dB = evaluate_err(f,s21dB);
      if pattern_search_step == 0 then
        dX = dX/2; // search gave single invalid point, go back to base but force smaller step
      end;  
      mfprintf(log_fhd,"* pattern_search_step = %d failed \n", pattern_search_step);
    end; 
    opt_run = opt_run + 1;
  end

  while (( dX > dX_min ) & (opt_run < opt_run_max) & (found_flag == 0))
    vectors_C = explore_C();
    vectors_L = explore_L();
    // if explore vectors are non zero
    if (nnz(vectors_C)>0) | (nnz(vectors_L)>0) then 
      // move using exploratory vectors
      CV= CV_0.*(1+dX.*vectors_C);
      LV= LV_0.*(1+dX.*vectors_L);
      opt_run = opt_run + 1;
      mfprintf(log_fhd,"* base check opt_run = %d \n", opt_run);
      set_inc(path$, inc$);
      [f, KU2, s21dB] = run_amp(path$, proj$);
      err_dB = evaluate_err(f,s21dB);      
      if err_dB < err_dB_min then
        found_flag = 1;
        pattern_search_step = 0; // next step would be a pattern_search step;
        CV_0 = CV
        LV_0 = LV
        err_dB_min = err_dB        
        plot2d(f/MHz, s21dB, style=5);
        p=get("hdl");
        p.children.line_style=3;
        mfprintf(log_fhd,"* base step successful - err_dB_min = %f \n", err_dB_min);
      else        
        dX = dX/2; // explore gave invalid point 
        plot2d(f/MHz, s21dB, style=2);
        p=get("hdl");
        p.children.line_style=3;
        mfprintf(log_fhd,"* base step failed - new step size dX = %f \n", dX);
      end
    else
       dX = dX/2; // explore have nothing to try
       mfprintf(log_fhd,"* explore failed - new step size dX = %f \n", dX);
    end  
  
  end // explore loop 

end    // main loop

CV = CV_0
LV = LV_0
set_inc(path$, inc$);
[f, KU2, s21dB] = run_amp(path$, proj$);
err_dB = evaluate_err(f,s21dB);
plot2d(f/MHz, s21dB, style=5);
p=get("hdl");
p.children.line_style = 1; // solid
p.children.foreground = 5; // red
p.children.thickness = 2; //thick

mfprintf(log_fhd,"* This is the best result\n err_dB = %f \n", err_dB);
mfprintf(log_fhd,"* opt_run =%d, dX =%f\n", opt_run, dX);
printf("* This is the best result\n err_dB = %f \n", err_dB);
printf("* opt_run =%d, dX =%f\n", opt_run, dX);
mfprintf(log_fhd,"* That is all, folks\n");
printf("That is all, folks\n");
mclose('all');


