// optimisation of a filter
// Hooke-Jeeves Pattern Search with relative change of params
// for lossy filter - 
// Caps with $MOD FQ MODCx 
// C1..C4
// Inductors with $MOD FQ MODLx
// L1..L3

clear;
clearglobal;
clc;
lines(0);
chdir(get_absolute_file_path('opt_h_j_hq_ps_max_std.sce'));

// ----------------------------------------------------------
// ----------------------------------------------------------
// ----------------------------------------------------------
// Error Function TYPE - 
// PS_MAX - error = max (Pass Band) + max (Stop Band)  
// PS_SUM - error = sum (Pass Band) + sum (Stop Band)
// PTS_MAX - error =  max (Pass Band) + max (Trans Band) + max (Stop Band)  
// PTS_SUM - error = sum (Pass Band) + sum(Trans Band)+ sum (Stop Band)

ERR_FUNC_TYPE = 'PS_MAX'
FQ_MOD = 'HIGH_Q'

path$ = "\jobs\Amp\examples\ex6\flp_hq_ps_max_std\"

proj$  = "flp_ch_1dB_1G0_7th.in"
inc$   = "flp_ch_1dB_1G0_7th.inc"
ref$   = "flp_ch_1dB_1G0_7th_ref.in"
ideal$ = "flp_ch_1dB_1G0_7th_ideal.in"

// number of capacitors
NC=4;
// number of inductors
NL=3;

// PARAMETERS OF THE OPTIMISATION RUN
// log_version
logver$ = "1";
// low pass end frequency
LP_FREQ = 1.0E+9;
// low pass ripples
PB_Ripples_dB = 1.0;
// stop frequency
ST_FREQ=2.4E+9;
// stop attenuation
ST_Att_dB = -80;
// transition frequency start
TB_FREQ = 1.5E+9;
// transition attenuation start
TB_Att_dB = -40;
// initial exploratory step for Caps and Ind
dX = 0.10;
// minimal exploratory step for Caps and Ind
dX_min = 0.001;
// max amp calls
opt_run_max = 150;
// Pass_Band Error weight
PB_Weight = 1.0;
// Transition_Band Error weight
TB_Weight = 1.0;
// Stop_Band Error weight
SB_Weight = 1.0;
// Pattern search gain
PS_Gain = 1.0;

exec('opt_h_j_std_core.sci');

