// preferred number optimisation of a low pass filter
// Caps with $MOD FQ MODCx 
// C1..C4
// Inductors with $MOD FQ MODLx
// L1..L3

clear;
clearglobal;
clc;
lines(0);
chdir(get_absolute_file_path('pn_ps_sum_le12_ce12.sce'));
exec("..\..\..\_sci\p_numbers.sci");

// ----------------------------------------------------------
// ----------------------------------------------------------
// ----------------------------------------------------------
// Error Function TYPE - 
// PS_MAX - error = max (Pass Band) + max (Stop Band)  
// PS_SUM - error = sum (Pass Band) + sum (Stop Band)
// PTS_MAX - error =  max (Pass Band) + max (Trans Band) + max (Stop Band)  
// PTS_SUM - error = sum (Pass Band) + sum(Trans Band)+ sum (Stop Band)

ERR_FUNC_TYPE = 'PS_SUM'
FQ_MOD = 'HIGH_Q'

path$ = "\jobs\Amp\examples\ex6\pn_ps_sum_le12_ce12\"

proj$  = "flp_hq_1G0_7th.in"
inc$   = "flp_hq_1G0_7th.inc"
ref$   = "flp_hq_1G0_7th_ref.in"
ideal$ = "flp_ch_1dB_1G0_7th_ideal.in"

// number of capacitors
NC=4;
// number of inductors
NL=3;
// preffered numbers
// C E24 10%
C_E=E12;
// L E12 10%
L_E=E12;

// PARAMETERS OF THE OPTIMISATION RUN
// log_version
logver$ = "1";
// low pass end frequency
LP_FREQ = 1.0E+9;
// low pass ripples
PB_Ripples_dB = 1.0;
// stop frequency
ST_FREQ=2.4E+9;
// stop attenuation
ST_Att_dB = -80;
// transition frequency start
TB_FREQ = 1.5E+9;
// transition attenuation start
TB_Att_dB = -40;
// Pass_Band Error weight 
PB_Weight = 1.0;
// Transition_Band Error weight
TB_Weight = 1.0;
// Stop_Band Error weight
SB_Weight = 1.0;

exec('pref_numb_core.sci');

