// runs of of Monte Carlo analysis of a filter
clear;
clearglobal;
clc;
lines(0);
chdir(get_absolute_file_path('sens_mc.sce'));

proj$ = "flp_hq_1G0_7th_opt_mc.in"
inc$ =  "flp_hq_1G0_7th_opt_mc.inc"
proj_path$ = "\jobs\Amp\examples\ex6\sens_mc\"

//number of  Monte Carlo runs
RUNS = 100;

// number of capacitors - excluding parasitics generated by MODELS
NC=4;
// number of inductors - excluding parasitics generated by MODELS
NL=3;
// 10% is 3 sigma variation for Caps
dC = 0.1;
// 10% is 3 sigma variation for Inductors
dL = 0.1;

// ----------------------------------------------------------
// open and scan *.m0 file to get
// global Tmajor Tmidlle Tminor Tname FN DN FD PN PV
// global XN XV
// global T FN DN FD PN PV
// DN - DATANAME, FN-FILENAME
// PN - PARAM_NAME, PV - PARAM_VALUE
exec("..\..\..\_sci\m0_scan_param1.sci");
exec("..\..\..\_sci\m0_data.sci");
amp$ = "\jobs\Amp\exe\Amp.exe"


[x_path,p_fname,p_extension]=fileparts(proj$);

inc_fhd=mopen(proj_path$+inc$,'w');
mfprintf(inc_fhd,"%s\n","* reset by scicoslab");
mclose(inc_fhd);

amp_err = run(amp$, proj_path$, proj$)

m0$=proj_path$+"_m\"+p_fname+".m0";
[m_path,m_fname,m_extension]=fileparts(m0$);
// Number of PARAMS
PAR = 0;
parse_m0(m0$, PAR);
TF1$='K_U2_V1';
index1=find_dataname_indexes(TF1$);
if (index1==[]) | (length(index1)> 1) abort; end;
filename1$ = m_path+FN(index1)
[f,KU2_A] = tf_read(filename1$); 

[KU2_AdB,phiX]=dbphi(KU2_A);
s21dB_A=KU2_AdB+20*log10(2);// s21=2*KU2

plot1_init();
plot1_tfdB(f,[s21dB_A],['s21dB'],[5]);

v1$=proj_path$+"_m\"+p_fname+".v1";
parse_vx(v1$);

XV_0 = XV;
XN_0 = XN;

// find indexes of C1..C4
ci=[];
for n=1:NC
 ci(n) = find(XN == 'C'+string(n));
end 

// find indexes of L1..L3
li=[];
for n=1:NL
 li(n) = find(XN == 'L'+string(n));
end 

for r=1:RUNS
  
  // normal distribution of deviations
  // dC/C for caps [-3 sigma .. + 3 sigma] 
  dc_C=grand(NC,1,'nor',0.0,dC/3);
  // dL/L for inds [-3 sigma .. + 3 sigma]
  dl_L=grand(NL,1,'nor',0.0,dL/3);

  inc_fhd=mopen(proj_path$+inc$,'w');
  mfprintf(inc_fhd,"%s\n","* set by scicoslab");
  for i=1:NC
    mfprintf(inc_fhd,"$LET %s %G \n", XN_0(ci(i)), XV_0(ci(i))*(1+dc_C(i)));
  end
  for i=1:NL
    mfprintf(inc_fhd,"$LET %s %G \n", XN_0(li(i)), XV_0(li(i))*(1+dl_L(i)));
  end
  mclose(inc_fhd);
  r
  amp_err = run(amp$, proj_path$, proj$);
  parse_m0(m0$, PAR);
  TF1$='K_U2_V1';
  index1=find_dataname_indexes(TF1$);
  if (index1==[]) | (length(index1)> 1) abort; end;
  filename1$ = m_path+FN(index1);
  [f,KU2_B] = tf_read(filename1$); 

  [KU2dB_B,phiX]=dbphi(KU2_B);
  s21dB_B=KU2dB_B+20*log10(2);// s21=2*KU2

  plot2d(f/MHz, s21dB_B, style=2);
  p=get("hdl");
  p.children.line_style=3;

end
plot2d(f/MHz, s21dB_A, style=5);
p=get("hdl");
p.children.thickness=2;


