// calc sensitivities of a filter - as +/-3 sigma - (Nsigma)
clear;
clearglobal;
clc;
lines(0);
chdir(get_absolute_file_path('sens_std.sce'));
// ----------------------------------------------------------

path$ = "\jobs\Amp\examples\ex6\sens_std\"
proj$  = "flp_hq_1G0_7th_opt_sens.in"

Nsigma = 3;

// extract file_name for project
[x_path,p_fname,p_ext]=fileparts(proj$);
m0$=path$+"_m\"+p_fname+".m0";

// number of capacitors
NC=4;
// number of inductors
NL=3;
// Number of PARAMS
PAR = 0;
exec("..\..\..\_sci\m0_scan_param1.sci");
exec("..\..\..\_sci\m0_data.sci");
amp$ = "\jobs\Amp\exe\Amp.exe"

[p$,f_n$,ext$]=fileparts(proj$);
m0$=path$+"_m\"+f_n$+".m0";
[m_path$,m_fname$,m_extension$]=fileparts(m0$);
amp_err = run(amp$, path$, proj$);
parse_m0(m0$, PAR);
[f,KU2] = tf_read(m_path$+FN(find_dataname_indexes('K_U2_V1'))); 
[KU2_dB,phiX] = dbphi(KU2);
s21_dB = KU2_dB + 20*log10(2);// s21=2*KU2  

STF1_C$='S_K_U2_V1_C';
for c=1:NC
  STF1_Cx$='S_K_U2_V1_C'+string(c);
  index_c=find_dataname_indexes(STF1_Cx$);
  if (index_c==[]) | (length(index_c)> 1) then print index_c; abort; end;  
  [fx,TF] = tf_read(m_path$+FN(index_c));
  SKU_C(:,c)=real(TF); // 
end

STF1_L$='S_K_U2_V1_L';
for l=1:NL
  STF1_Lx$='S_K_U2_V1_L'+string(l);
  index_l=find_dataname_indexes(STF1_Lx$);
  if (index_l==[]) | (length(index_l)> 1) then print index_l; abort; end;
  [fx,TF] = tf_read(m_path$+FN(index_l));
  SKU_L(:,l)=real(TF);
end

// 10% is 3 sigma variation
sigmaC = 0.1/3;
// 10% is 3 sigma variation
sigmaL = 0.1/3;
sigmaK = sqrt(sum(SKU_C.*SKU_C.*((sigmaC)^2),'c') + sum(SKU_L.*SKU_L.*((sigmaL)^2),'c') );
// if 3*sigmaK >=1 SATURATE it at almost 1 
sigmaK( sigmaK >= 1.0/Nsigma )  = 0.999/Nsigma;   
// if 3*sigmaK <= -1 SATURATE it at almost -1 
sigmaK( sigmaK <= -1.0/Nsigma )  = -0.999/Nsigma;   

KU2max = abs(KU2).*(1+Nsigma.*sigmaK);
KU2min = abs(KU2).*(1-Nsigma.*sigmaK);
KU2dB=20*log10(abs(KU2));
KU2dBmax=20*log10(KU2max);
KU2dBmin=20*log10(KU2min);
s21dB=KU2dB+20*log10(2);// s21=2*KU2
s21dBmax=KU2dBmax+20*log10(2);// s21=2*KU2
s21dBmin=KU2dBmin+20*log10(2);// s21=2*KU2

plot1_init();
plot1_tfdB(f,[s21dB,s21dBmax,s21dBmin],['s21dB', 's21dBmax', 's21dBmin'],[2,5,1]);

f_900M = max(find(f<=0.9E+9));
disp('[s21dB(f_900M), s21dBmax(f_900M), s21dBmin(f_900M)]');
disp([s21dB(f_900M), s21dBmax(f_900M), s21dBmin(f_900M)]); 

f_1G = max(find(f<=1.0E+9));
disp('[s21dB(f_1G), s21dBmax(f_1G), s21dBmin(f_1G)]');
disp([s21dB(f_1G), s21dBmax(f_1G), s21dBmin(f_1G)]);

f_2G4 = max(find(f<=2.4E+9));
disp('[s21dB(f_2G4), s21dBmax(f_2G4), s21dBmin(f_2G4)]');
disp([s21dB(f_2G4), s21dBmax(f_2G4), s21dBmin(f_2G4)]);
