/*xxx
* \brief - abstraction layer - sci_base API
* \author maki
 */

// ---- ITPP  ----
#include "copyright.h"

// ----- SCI -----
#include "sci\_sci_base.hpp"
#include "sci\_sci_api.hpp"
#include "sci\_sci_var.hpp"
#include "sci\_sci_exception.hpp"

// ----- all sci_type devices here -----
#include "sci\_sci_lib.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

// creates derived instances 
sci_base* sci_base::create(int sci_type)
{
  void *pc;
  void *p = NULL;
  switch(sci_type)
  {
    case SCI_FIR:
    {
      pc = new sci_fir;
      return (((sci_fir *)(pc))->create(sci_type));
    }
    case SCI_FIR_X:
    {
      pc = new sci_fir_x;
      return (((sci_fir_x *)(pc))->create(sci_type));
    }
    case SCI_LFSR:
    {
      pc = new sci_lfsr;
      return (((sci_lfsr *)(pc))->create(sci_type));
    }
    case SCI_COUNTER:
    {
      pc = new sci_counter;
      return (((sci_counter *)(pc))->create(sci_type));
    }
    case SCI_LSR:
    {
      pc = new sci_lsr;
      return (((sci_lsr *)(pc))->create(sci_type));
    }
    case SCI_BERT:
    {
      pc = new sci_bert;
      return (((sci_bert *)(pc))->create(sci_type));
    }
    case SCI_QAM_MOD:
    {
      pc = new sci_qam_mod;
      return (((sci_qam_mod *)(pc))->create(sci_type));
    }
    case SCI_QAM_DEM:
    {
      pc = new sci_qam_dem;
      return (((sci_qam_dem *)(pc))->create(sci_type));
    }
    case SCI_BIN2INT:
    {
      pc = new sci_bin2int;
      return (((sci_bin2int *)(pc))->create(sci_type));
    }
    case SCI_INT2BIN:
    {
      pc = new sci_int2bin;
      return (((sci_int2bin *)(pc))->create(sci_type));
    }
    case SCI_RMS:
    {
      pc = new sci_rms;
      return (((sci_rms *)(pc))->create(sci_type));
    }
    case SCI_RMS_X:
    {
      pc = new sci_rms_x;
      return (((sci_rms_x *)(pc))->create(sci_type));
    }
    case SCI_WGN:
    {
      pc = new sci_wgn;
      return (((sci_wgn *)(pc))->create(sci_type));
    }
    case SCI_WGN_X:
    {
      pc = new sci_wgn_x;
      return (((sci_wgn_x *)(pc))->create(sci_type));
    }
    case SCI_FIR_UP:
    {
      pc = new sci_fir_up;
      return (((sci_fir_up *)(pc))->create(sci_type));
    }
    case SCI_FIR_UP_X:
    {
      pc = new sci_fir_up_x;
      return (((sci_fir_up_x *)(pc))->create(sci_type));
    }
    case SCI_AMP:
    {
      pc = new sci_amp;
      return (((sci_amp *)(pc))->create(sci_type));
    }
    case SCI_AMP_X:
    {
      pc = new sci_amp_x;
      return (((sci_amp_x *)(pc))->create(sci_type));
    }
    case SCI_MIX:
    {
      pc = new sci_mix;
      return (((sci_mix *)(pc))->create(sci_type));
    }
    case SCI_MIX_X:
    {
      pc = new sci_mix_x;
      return (((sci_mix_x *)(pc))->create(sci_type));
    }
    case SCI_NCO:
    {
      pc = new sci_nco;
      return (((sci_nco *)(pc))->create(sci_type));
    }
    case SCI_VCO:
    {
      pc = new sci_vco;
      return (((sci_vco *)(pc))->create(sci_type));
    }
    case SCI_EJP:
    {
      pc = new sci_ejp;
      return (((sci_ejp *)(pc))->create(sci_type));
    }
    case SCI_AP2IQ:
    {
      pc = new sci_ap2iq;
      return (((sci_ap2iq *)(pc))->create(sci_type));
    }
    case SCI_IQ2AP:
    {
      pc = new sci_iq2ap;
      return (((sci_iq2ap *)(pc))->create(sci_type));
    }
    case SCI_CIRCBUFF:
    {
      pc = new sci_circbuff;
      return (((sci_circbuff *)(pc))->create(sci_type));
    }
    case SCI_CIRCBUFF_X:
    {
      pc = new sci_circbuff_x;
      return (((sci_circbuff_x *)(pc))->create(sci_type));
    }
    case SCI_PSK_MOD:
    {
      pc = new sci_psk_mod;
      return (((sci_psk_mod *)(pc))->create(sci_type));
    }
    case SCI_PSK_DEM:
    {
      pc = new sci_psk_dem;
      return (((sci_psk_dem *)(pc))->create(sci_type));
    }
    case SCI_SRC:
    {
      pc = new sci_src;
      return (((sci_src *)(pc))->create(sci_type));
    }
    case SCI_SRC_X:
    {
      pc = new sci_src_x;
      return (((sci_src_x *)(pc))->create(sci_type));
    }
    case SCI_CASDEC_X:
    {
      pc = new sci_casdec_x;
      return (((sci_casdec_x *)(pc))->create(sci_type));
    }
    case SCI_COFDM_MOD:
    {
      pc = new sci_cofdm_mod;
      return (((sci_cofdm_mod *)(pc))->create(sci_type));
    }
    case SCI_COFDM_DEM:
    {
      pc = new sci_cofdm_dem;
      return (((sci_cofdm_dem *)(pc))->create(sci_type));
    }
    case SCI_COFDM_MAP:
    {
      pc = new sci_cofdm_map;
      return (((sci_cofdm_map *)(pc))->create(sci_type));
    }
    case SCI_COFDM_DEMAP:
    {
      pc = new sci_cofdm_demap;
      return (((sci_cofdm_demap *)(pc))->create(sci_type));
    }
    case SCI_COFDM_SEL:
    {
      pc = new sci_cofdm_sel;
      return (((sci_cofdm_sel *)(pc))->create(sci_type));
    }
    case SCI_BINBUFF:
    {
      pc = new sci_binbuff;
      return (((sci_binbuff *)(pc))->create(sci_type));
    }
    case SCI_PAM_MOD:
    {
      pc = new sci_pam_mod;
      return (((sci_pam_mod *)(pc))->create(sci_type));
    }
    case SCI_PAM_DEM:
    {
      pc = new sci_pam_dem;
      return (((sci_pam_dem *)(pc))->create(sci_type));
    }
    case SCI_TEDG_X:
    {
      pc = new sci_tedg_x;
      return (((sci_tedg_x *)(pc))->create(sci_type));
    }


    default:
    {
      throw sci_exception("sci_base::create - unknown type", sci_type);
    }

  }
}

// create derived sci_xxx class defined by mod
sci_base* sci_create(int mod)
{
  sci_base b;		// created and destroyed on exit used only as a vehicle for derived
  sci_base *p_sci = &b;

  return (b.create(mod));
}

// executes set method of sci_xxx class derived from sci_base
void sci_set(sci_base *p, int param, sci_var* p_v)
{
  try
  {
    p->set(param, p_v);
  }
  catch(sci_exception except)
  {
    cout << "\n sci_set exception:" << except.get_msg() << ":" << except.get_info() << endl;
    throw; //re-throw for sci_if - if not used this will create abort
  }
  return;
}

// executes get method of sci_xxx class derived from sci_base
sci_var* sci_get(sci_base *p, int param)
{
  sci_var *p_v;
  try
  {
    p_v = p->get(param);
  }
  catch(sci_exception except)
  {
    cout << "\n sci_get exception:" << except.get_msg() << ":" << except.get_info() << endl;
    throw;  //re-throw for sci_if - if not used this will create abort
  }
  return (p_v);
}

// executes exec method of sci_xxx class derived from sci_base
void sci_exec(sci_base *p, int command)
{
  try
  {
    p->exec(command);
  }
  catch(sci_exception except)
  {
    cout << "\n sci_exec exception:" << except.get_msg() << ":" << except.get_info() << endl;
    throw;  //re-throw for sci_if - if not used this will create abort
  }
  return;
}


// executes gen method of sci_xxx class derived from sci_base
sci_var* sci_gen(sci_base *p, sci_var* p_v_ce)
{
  sci_var *p_y;
  try
  {
    p_y = p->gen(p_v_ce);
  }
  catch(sci_exception except)
  {
    cout << "\n sci_gen exception:" << except.get_msg() << ":" << except.get_info() << endl;
    throw;  //re-throw for sci_if - if not used this will create abort
  }
  return (p_y);
}

// executes proc method of sci_xxx class derived from sci_base
sci_var* sci_proc(sci_base *p, sci_var* p_v_ce, sci_var*p_v_x)
{
  sci_var *p_y;
  try
  {
    p_y = p->proc(p_v_ce, p_v_x);
  }
  catch(sci_exception except)
  {
    cout << "\n sci_proc exception:" << except.get_msg() << ":" << except.get_info() << endl;
    throw;  //re-throw for sci_if - if not used this will create abort
  }
  return (p_y);
}

// proc method of sci_xxx class derived from sci_base
void sci_destroy(sci_base *p)
{
  try
  {
    p->destroy();
  }
  catch(sci_exception except)
  {
    cout << "\n sci_destroy exception:" << except.get_msg() << ":" << except.get_info() << endl;
    throw;  //re-throw for sci_if - if not used this will create abort
  }
  try
  {
    delete p;
  }
  catch(...)
  {
    throw sci_exception("sci_destroy <delete p> exception ");
  }
  return;
}
