/*xxx
* \brief - Convert it++ classes into sci_sci_var object. Newly created objects are stored on heap
* \author maki
*/

#include "sci\_sci_create_sci_var.hpp"

namespace SCI
{

/// \cond SCI_VAR_DOC
/// this should prevent doxygen from documenting functions below

// int to sci_var_ivec
sci_var* create_sci_var(int* p_int)
{
  sci_var *p = new sci_var_int;

  (dynamic_cast<sci_var_int *>(p))->v = *p_int;
  return (p);
};

// double to sci_var_vec
sci_var* create_sci_var(double* p_double)
{
  sci_var *p = new sci_var_double;
  (dynamic_cast<sci_var_double *>(p))->v = *p_double;
  return (p);
};

//! bool to sci_var_bvec
sci_var* create_sci_var(bool* p_bool)
{
  sci_var *p = new sci_var_bool;
  (dynamic_cast<sci_var_bool *>(p))->v = *p_bool;
  return (p);
};

//! complex to sci_var_cvec
sci_var* create_sci_var(std::complex<double>* p_complex)
{
  sci_var *p = new sci_var_complex;
  (dynamic_cast<sci_var_complex *>(p))->v = *p_complex;
  return (p);
};

// vec to sci_var_vec
sci_var* create_sci_var(vec* p_vector)
{
  sci_var *p = new sci_var_vec;
  (dynamic_cast<sci_var_vec *>(p))->v = *p_vector;
  return (p);
};

// ivec to sci_var_ivec
sci_var* create_sci_var(ivec* p_ivector)
{
  sci_var *p = new sci_var_ivec;
  (dynamic_cast<sci_var_ivec *>(p))->v = *p_ivector;
  return (p);
};

// cvec to sci_var_cvec
sci_var* create_sci_var(cvec* p_cvector)
{
  sci_var *p = new sci_var_cvec;
  (dynamic_cast<sci_var_cvec *>(p))->v = *p_cvector;
  return (p);
};

// bvec to sci_var_bvec
sci_var* create_sci_var(bvec* p_bvector)
{
  sci_var *p = new sci_var_bvec;
  (dynamic_cast<sci_var_bvec *>(p))->v = *p_bvector;
  return (p);
};

// mat to sci_var_mat
sci_var* create_sci_var(mat* p_matrix)
{
  sci_var *p = new sci_var_mat;
  (dynamic_cast<sci_var_mat *>(p))->v = *p_matrix;
  return (p);
};

// imat to sci_var_imat
sci_var* create_sci_var(imat* p_imatrix)
{
  sci_var *p = new sci_var_imat;
  (dynamic_cast<sci_var_imat *>(p))->v = *p_imatrix;
  return (p);
};

// cmat to sci_var_cmat
sci_var* create_sci_var(cmat* p_cmatrix)
{
  sci_var *p = new sci_var_cmat;
  (dynamic_cast<sci_var_cmat *>(p))->v = *p_cmatrix;
  return (p);
};

// bmat to sci_var_bmat
sci_var* create_sci_var(bmat* p_bmatrix)
{
  sci_var *p = new sci_var_bmat;
  (dynamic_cast<sci_var_bmat *>(p))->v = *p_bmatrix;
  return (p);
};

/// end of condition preventing doxygen from documenting classes
/// \endcond

} // namespace SCI
