/*xxx
 * \brief - emulation of scilab syntax using sci layer API and helper functions
 * \author maki
 */

// ----- SCI -----
#include "sci\_sci_emu.hpp"
#include "sci\_sci_api.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

namespace SCI
{

/// \cond EMU_DOC
/// this should prevent doxygen from documenting functions below

void sci_var_value_get(sci_var* p_v, double *p_double)
{
  *p_double = ((dynamic_cast<sci_var_double *>(p_v))->get_double());
};

void sci_var_value_get(sci_var* p_v, vec *p_vec)
{
  *p_vec = ((dynamic_cast<sci_var_vec *>(p_v))->get_vec());
};

void sci_var_value_get(sci_var* p_v, mat *p_mat)
{
  *p_mat = ((dynamic_cast<sci_var_mat *>(p_v))->get_mat());
};

void sci_var_value_get(sci_var* p_v, int *p_int)
{
  *p_int = ((dynamic_cast<sci_var_int *>(p_v))->get_int());
};

void sci_var_value_get(sci_var* p_v, ivec *p_ivec)
{
  *p_ivec = ((dynamic_cast<sci_var_ivec *>(p_v))->get_ivec());
};

void sci_var_value_get(sci_var* p_v, imat *p_imat)
{
  *p_imat = ((dynamic_cast<sci_var_imat *>(p_v))->get_imat());
};

void sci_var_value_get(sci_var* p_v, bool *p_bool)
{
  *p_bool = ((dynamic_cast<sci_var_bool *>(p_v))->get_bool());
};

void sci_var_value_get(sci_var* p_v, bvec *p_bvec)
{
  *p_bvec = ((dynamic_cast<sci_var_bvec *>(p_v))->get_bvec());
};

void sci_var_value_get(sci_var* p_v, bmat *p_bmat)
{
  *p_bmat = ((dynamic_cast<sci_var_bmat *>(p_v))->get_bmat());
};

void sci_var_value_get(sci_var* p_v, complex<double> *p_complex)
{
  *p_complex = ((dynamic_cast<sci_var_complex *>(p_v))->get_complex());
};


void sci_var_value_get(sci_var* p_v, cvec *p_cvec)
{
  *p_cvec = ((dynamic_cast<sci_var_cvec *>(p_v))->get_cvec());
};

void sci_var_value_get(sci_var* p_v, cmat *p_cmat)
{
  *p_cmat = ((dynamic_cast<sci_var_cmat *>(p_v))->get_cmat());
};

sci_base* EMU_SCI_CREATE(int sci_type)
{
  return (sci_create(sci_type));
}

void EMU_SCI_EXEC(sci_base *p_dev, int sci_command)
{
  return (sci_exec(p_dev, sci_command));
}

void EMU_SCI_DESTROY(sci_base *p_dev)
{
  return (sci_destroy(p_dev));
}

/// end of condition preventing doxygen from documenting classes
/// \endcond

};
