/*xxx
* \brief - second layer interface of the sci_gateway
* \author maki
*/

#include <string.h>

//#include "stdafx.h"


// ----- SCI -----
#include "sci\_sci_api.hpp"
#include "sci\_sci_enum_def.h"
#include "sci\_sci_if_create_var.hpp"
#include "sci\_sci_exception.hpp"

#include "sci\_sci_if.h"

#include "__debug.h"

static void sci_if_error_handler(string sci_err_sting, sci_exception except, int e)
{
  cout << sci_err_sting << except.get_msg() << ":" << except.get_info() << endl;
  sci_if_err_msg_set(except.get_msg());
  sci_if_info_set(except.get_info());
  sci_if_err_set(e);
}

static void sci_if_error_handler(string sci_err_sting, int e)
{
  cout << sci_err_sting << endl;
  sci_if_err_msg_set(sci_err_sting.c_str());
  sci_if_info_set(-1);
  sci_if_err_set(e);
}

// push data from c++ heap into sci_stack
void sci_if_copy_var(struct var_struct *p_s_v)
{
  try
  {
    push(p_s_v);
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_copy_var::push() thrown sci_exception :", except, -1);
  }
  return;
}

// remove data from c++ heap
void sci_if_delete_var(struct var_struct *p_s_v)
{
  try
  {
    delete((sci_var *)(p_s_v->p_var));
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_delete_var::delete thrown sci_exception :", except, -1);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_delete_var::delete CRASHED !!!", -1);
  }
  return;
}

void * sci_if_create(int mod)
{
  void *p;

  debug_3("[sci_if_create] ..................... \r\n");
  try
  {
    p = (void *)sci_create(mod);
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_create::sci_create() thrown sci_exception :", except, SCI_ERR_UNKNOWN_MOD);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_delete_var::delete CRASHED !!!", -1);
  }
  debug_3("[sci_if_create] +++++++++++++++++++++ \r\n");
  return (p);
}

void sci_if_set(void *p_sci, int param, struct var_struct *p_s_v)
{
  sci_base *p_sci_base;
  sci_var *p_sci_var;

  debug_3("[sci_if_set] ..................... \r\n");


  try
  {
    p_sci_var = create_var(p_s_v); // create argument
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_set::create_var(p_s_v) thrown sci_exception :", except, SCI_ERR_BAD_VAR_TYPE);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_set::create_var(p_s_v) CRASHED !!!", SCI_ERR_BAD_VAR_TYPE);
  }

  try
  {
    p_sci_base = static_cast <sci_base *>(p_sci);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_set::static_cast<sci_base *>(p_sci) CRASHED !!!", -1);
  }

  try
  {
    sci_set(p_sci_base, param, p_sci_var);
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_set::sci_set(p_sci_base, param, p_sci_var) thrown sci_exception :", except, SCI_ERR_UNKNOWN_PARA);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_set::sci_set(p_sci_base, param, p_sci_var) CRASHED !!!", -1);
  }

  try
  {
    delete p_sci_var; // delete argument
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_set::delete(p_sci_var) CRASHED !!!", -1);
  }

  debug_3("[sci_if_set] +++++++++++++++++++++ \r\n");
  return;
}

struct var_struct sci_if_get(void *p_sci, int param)
{
  sci_var *p_sci_var_y;
  sci_base *p_sci_base;
  var_struct var_struct_y;

  debug_3("[sci_if_get] ..................... \r\n");

  try
  {
    p_sci_base = static_cast <sci_base *>(p_sci);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_get::static_cast<sci_base *>(p_sci) CRASHED !!!", -1);
  }

  try
  {
    p_sci_var_y = sci_get(p_sci_base, param);
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_get::sci_get(p_sci_base, param) thrown sci_exception :", except, SCI_ERR_UNKNOWN_PARA);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_get::sci_get(p_sci_base, param) CRASHED !!!", -1);
  }


  try
  {
    var_struct_y = var_to_struct(p_sci_var_y);
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_get::var_to_struct(p_sci_var) thrown sci_exception :", except, SCI_ERR_BAD_VAR_TYPE);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_get::var_to_struct(p_var) CRASHED !!!", -1);
  }

  debug_3("[sci_if_get] +++++++++++++++++++++ \r\n");

  return (var_struct_y);
}

// interface between sci_cpp and sci_stack
void sci_if_exec(void *p_sci, int command)
{
  sci_base *p_sci_base;

  debug_3("[sci_if_exec] ..................... \r\n");

  try
  {
    p_sci_base = static_cast <sci_base *>(p_sci);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_exec::static_cast<sci_base *>(p_sci) CRASHED !!!", -1);
  }

  try
  {
    sci_exec(p_sci_base, command);
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_exec::sci_exec(p_sci_base, command) thrown sci_exception :", except, SCI_ERR_UNKNOWN_COMD);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_exec::sci_exec(p_sci_base, command) CRASHED !!!", -1);
  }

  debug_3("[sci_if_exec] +++++++++++++++++++++ \r\n");
  return ;
}

struct var_struct sci_if_gen(void *p_sci, struct var_struct* p_s_ce)
{
  sci_var *p_sci_var_ce, *p_sci_var_y;
  sci_base *p_sci_base;
  var_struct var_struct_y;

  debug_3("[sci_if_gen] ..................... \r\n");

  try
  {
    p_sci_base = static_cast <sci_base *>(p_sci);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_gen::static_cast<sci_base *>(p_sci) CRASHED !!!", -1);
  }

  try
  {
    p_sci_var_ce = create_var(p_s_ce); // create argument
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_gen::create_var(p_s_ce) thrown sci_exception :", except, SCI_ERR_BAD_VAR_TYPE);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_gen::create_var(p_s_ce) CRASHED !!!", SCI_ERR_BAD_VAR_TYPE);
  }

  try
  {
    p_sci_var_y = sci_gen(p_sci_base, p_sci_var_ce);
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_gen::sci_gen(p_sci_base, p_sci_var_ce) thrown sci_exception :", except, SCI_ERR_UNKNOWN_PARA);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_gen::sci_gen(p_sci_base, p_sci_var_ce) CRASHED !!!", -1);
  }

  try
  {
    delete p_sci_var_ce; // delete argument
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_gen::delete(p_var_ce) CRASHED !!!", -1);
  }

  // var_struct
  try
  {
    var_struct_y = var_to_struct(p_sci_var_y);
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_gen::var_to_struct(p_var) thrown sci_exception :", except, SCI_ERR_BAD_VAR_TYPE);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_gen::var_to_struct(p_var) CRASHED !!!", -1);
  }

  debug_3("[sci_if_gen] +++++++++++++++++++++ \r\n");
  return (var_struct_y);

}

// interface between sci_cpp and sci_stack
struct var_struct sci_if_proc(void *p_sci, struct var_struct* p_s_ce, struct var_struct *p_s_x)
{
  sci_var *p_sci_var_ce, *p_sci_var_x, *p_sci_var_y;
  sci_base *p_sci_base;
  var_struct var_struct_y;

  debug_3("[sci_if_proc] ..................... \r\n");

  try
  {
    p_sci_base = static_cast <sci_base *>(p_sci);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_proc::static_cast<sci_base *>(p_sci) CRASHED !!!", -1);
  }

  try
  {
    p_sci_var_ce = create_var(p_s_ce); // create argument
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_proc::create_var(p_s_ce) thrown sci_exception :", except, SCI_ERR_BAD_VAR_TYPE);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_proc::create_var(p_s_ce) CRASHED !!!", SCI_ERR_BAD_VAR_TYPE);
  }

  try
  {
    p_sci_var_x = create_var(p_s_x); // create argument
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_proc::create_var(p_s_x) thrown sci_exception :", except, SCI_ERR_BAD_VAR_TYPE);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_proc::create_var(p_s_x) CRASHED !!!", SCI_ERR_BAD_VAR_TYPE);
  }

  try
  {
    p_sci_var_y = sci_proc(p_sci_base, p_sci_var_ce, p_sci_var_x);
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_proc::sci_gen(p_sci_base, p_sci_var_ce, p_sci_var_x) thrown sci_exception :", except, SCI_ERR_UNKNOWN_PARA);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_proc::sci_gen(p_sci_base, p_sci_var_ce, p_sci_var_x) CRASHED !!!", -1);
  }

  try
  {
    delete p_sci_var_ce; // delete argument
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_proc::delete(p_var_ce) CRASHED !!!", -1);
  }

  try
  {
    delete p_sci_var_x; // delete argument
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_proc::delete(p_var_x) CRASHED !!!", -1);
  }

  // var_struct
  try
  {
    var_struct_y = var_to_struct(p_sci_var_y);
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_proc::var_to_struct(p_sci_var_y) thrown sci_exception :", except, SCI_ERR_BAD_VAR_TYPE);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_proc::var_to_struct(p_sci_var_y) CRASHED !!!", -1);
  }

  debug_3("[sci_if_proc] +++++++++++++++++++++ \r\n");
  return (var_struct_y);
}

// interface between sci_cpp and sci_stack
void sci_if_destroy(void *p_sci)
{
  sci_base *p_sci_base;

  debug_3("[sci_if_destroy] ..................... \r\n");

  try
  {
    p_sci_base = static_cast <sci_base *>(p_sci);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_destroy::static_cast<sci_base *>(p_sci) CRASHED !!!", -1);
  }

  try
  {
    sci_destroy(p_sci_base);
  }
  catch(sci_exception except)
  {
    sci_if_error_handler("sci_if_destroy::sci_destroy(p_sci_base) thrown sci_exception :", except, SCI_ERR_BAD_VAR_TYPE);
  }
  catch(...)
  {
    sci_if_error_handler("sci_if_destroy::sci_destroy(p_sci_base) CRASHED !!!", -1);
  }

  debug_3("[sci_if_destroy] +++++++++++++++++++++ \r\n");
  return;
}


