/*xxx
* \brief - conversions   var
* \author maki
*/

#include "sci\_sci_var.hpp"
#include "sci\_sci_if_op.hpp"

#include "sci\_sci_exception.hpp"
#include "sci\_sci_if_create_var.hpp"


// return struct with fields set by object methods
struct var_struct var_to_struct(sci_var *p_v)
{
  struct var_struct  s_v;

  s_v.sci_type = p_v->get_sci_type();
  s_v.rows = p_v->get_rows();	// var should know its size
  s_v.cols = p_v->get_cols(); // var should know its size
  s_v.p_var = (void *)p_v; // var pointer for getting data via push() into scilab stack
  return (s_v);
}

// create var from var struct
// don't try to optimize - leave it as is in closed brackets,
// even operation seems the same - but overloading is executed as expected
sci_var* create_var(struct var_struct *p_s_v)
{
  int var_type;

  var_type = p_s_v->sci_type;
  switch(var_type)
  {
    case SCI_TYPE_DOUBLE:
    {
      sci_var_double *p_v = new sci_var_double;
      pop(p_s_v, p_v);
      return (p_v);
    }

    case SCI_TYPE_INT:
    {
      sci_var_int *p_v = new sci_var_int;
      pop(p_s_v, p_v);
      return (p_v);
    }

    case SCI_TYPE_BOOL:
    {
      sci_var_bool *p_v = new sci_var_bool;
      pop(p_s_v, p_v);
      return (p_v);
    }

    case SCI_TYPE_COMPLEX:
    {
      sci_var_complex *p_v = new sci_var_complex;
      pop(p_s_v, p_v);
      return (p_v);
    }

    case SCI_TYPE_VEC:
    {
      sci_var_vec *p_v = new sci_var_vec;
      (p_v->v).set_length(p_s_v->rows * p_s_v->cols);
      pop(p_s_v, p_v);
      return (p_v);
    }

    case SCI_TYPE_IVEC:
    {
      sci_var_ivec *p_v = new sci_var_ivec;
      (p_v->v).set_length(p_s_v->rows * p_s_v->cols);
      pop(p_s_v, p_v);
      return (p_v);
    }

    case SCI_TYPE_BVEC:
    {
      sci_var_bvec *p_v = new sci_var_bvec;
      (p_v->v).set_length(p_s_v->rows * p_s_v->cols);
      pop(p_s_v, p_v);
      return (p_v);
    }

    case SCI_TYPE_CVEC:
    {
      sci_var_cvec *p_v = new sci_var_cvec;
      (p_v->v).set_length(p_s_v->rows * p_s_v->cols);
      pop(p_s_v, p_v);
      return (p_v);
    }

    case SCI_TYPE_MAT:
    {
      sci_var_mat *p_v = new sci_var_mat;
      (p_v->v).set_size(p_s_v->rows, p_s_v->cols);
      pop(p_s_v, p_v);
      return (p_v);
    }

    case SCI_TYPE_IMAT:
    {
      sci_var_imat *p_v = new sci_var_imat;
      (p_v->v).set_size(p_s_v->rows, p_s_v->cols);
      pop(p_s_v, p_v);
      return (p_v);
    }

    case SCI_TYPE_BMAT:
    {
      sci_var_bmat *p_v = new sci_var_bmat;
      (p_v->v).set_size(p_s_v->rows, p_s_v->cols);
      pop(p_s_v, p_v);
      return (p_v);
    }

    case SCI_TYPE_CMAT:
    {
      sci_var_cmat *p_v = new sci_var_cmat;
      (p_v->v).set_size(p_s_v->rows, p_s_v->cols);
      pop(p_s_v, p_v);
      return (p_v);
    }

    default:
      throw sci_exception("create_var - unknown type", var_type);
      break;
  }
  // this should not ever happen
  return(NULL);
}

inline void pop(struct var_struct *p_s_v, sci_var_double *p_sci_var)
{
  pop_from_ext_stack(p_sci_var->v, p_s_v);
}

inline void pop(struct var_struct *p_s_v, sci_var_int *p_sci_var)
{
  pop_from_ext_stack(p_sci_var->v, p_s_v);
}

inline void pop(struct var_struct *p_s_v, sci_var_bool *p_sci_var)
{
  pop_from_ext_stack(p_sci_var->v, p_s_v);
}

inline void pop(struct var_struct *p_s_v, sci_var_complex *p_sci_var)
{
  pop_from_ext_stack(p_sci_var->v, p_s_v);
}

inline void pop(struct var_struct *p_s_v, sci_var_vec *p_sci_var)
{
  p_sci_var->v <= p_s_v;
}

inline void pop(struct var_struct *p_s_v, sci_var_ivec *p_sci_var)
{
  p_sci_var->v <= p_s_v;
}

inline void pop(struct var_struct *p_s_v, sci_var_bvec *p_sci_var)
{
  p_sci_var->v <= p_s_v;
}

inline void pop(struct var_struct *p_s_v, sci_var_cvec *p_sci_var)
{
  p_sci_var->v <= p_s_v;
}

inline void pop(struct var_struct *p_s_v, sci_var_mat *p_sci_var)
{
  p_sci_var->v <= p_s_v;
}

inline void pop(struct var_struct *p_s_v, sci_var_imat *p_sci_var)
{
  p_sci_var->v <= p_s_v;
}

inline void pop(struct var_struct *p_s_v, sci_var_bmat *p_sci_var)
{
  p_sci_var->v <= p_s_v;
}

inline void pop(struct var_struct *p_s_v, sci_var_cmat *p_sci_var)
{
  p_sci_var->v <= p_s_v;
}

inline void push(struct var_struct *p_s_v, sci_var_double *p_sci_var)
{
  push_to_ext_stack(p_s_v, p_sci_var->v);
}

inline void push(struct var_struct *p_s_v, sci_var_int *p_sci_var)
{
  push_to_ext_stack(p_s_v, p_sci_var->v);
}

inline void push(struct var_struct *p_s_v, sci_var_bool *p_sci_var)
{
  push_to_ext_stack(p_s_v, p_sci_var->v);
}

inline void push(struct var_struct *p_s_v, sci_var_complex *p_sci_var)
{
  push_to_ext_stack(p_s_v, p_sci_var->v);
}

inline void push(struct var_struct *p_s_v, sci_var_vec *p_sci_var)
{
  p_s_v <= p_sci_var->v;
}

inline void push(struct var_struct *p_s_v, sci_var_ivec *p_sci_var)
{
  p_s_v <= p_sci_var->v;
}

inline void push(struct var_struct *p_s_v, sci_var_bvec *p_sci_var)
{
  p_s_v <= p_sci_var->v;
}

inline void push(struct var_struct *p_s_v, sci_var_cvec *p_sci_var)
{
  p_s_v <= p_sci_var->v;
}

inline void push(struct var_struct *p_s_v, sci_var_mat *p_sci_var)
{
  p_s_v <= p_sci_var->v;
}

inline void push(struct var_struct *p_s_v, sci_var_imat *p_sci_var)
{
  p_s_v <= p_sci_var->v;
}

inline void push(struct var_struct *p_s_v, sci_var_bmat *p_sci_var)
{
  p_s_v <= p_sci_var->v;
}

inline void push(struct var_struct *p_s_v, sci_var_cmat *p_sci_var)
{
  p_s_v <= p_sci_var->v;
}

// read comment about possible alternative with RTTI below
#if 1
void push(struct var_struct *p_s_v)
{
  int var_type;

  var_type = p_s_v->sci_type;
  switch(var_type)
  {
    case SCI_TYPE_DOUBLE:
    {
      sci_var_double *p_v = static_cast<sci_var_double *>(p_s_v->p_var);
      push(p_s_v, p_v);
    }
    break;

    case SCI_TYPE_INT:
    {
      sci_var_int *p_v = static_cast<sci_var_int *>(p_s_v->p_var);
      push(p_s_v, p_v);
    }
    break;

    case SCI_TYPE_BOOL:
    {
      sci_var_bool *p_v = static_cast<sci_var_bool *>(p_s_v->p_var);
      push(p_s_v, p_v);
    }
    break;

    case SCI_TYPE_COMPLEX:
    {
      sci_var_complex *p_v = static_cast<sci_var_complex *>(p_s_v->p_var);
      push(p_s_v, p_v);
    }
    break;

    case SCI_TYPE_VEC:
    {
      sci_var_vec *p_v = static_cast<sci_var_vec *>(p_s_v->p_var);
      push(p_s_v, p_v);
    }
    break;

    case SCI_TYPE_IVEC:
    {
      sci_var_ivec *p_v = static_cast<sci_var_ivec *>(p_s_v->p_var);
      push(p_s_v, p_v);
    }
    break;

    case SCI_TYPE_BVEC:
    {
      sci_var_bvec *p_v = static_cast<sci_var_bvec *>(p_s_v->p_var);
      push(p_s_v, p_v);
    }
    break;

    case SCI_TYPE_CVEC:
    {
      sci_var_cvec *p_v = static_cast<sci_var_cvec *>(p_s_v->p_var);
      push(p_s_v, p_v);
    }
    break;

    case SCI_TYPE_MAT:
    {
      sci_var_mat *p_v = static_cast<sci_var_mat *>(p_s_v->p_var);
      push(p_s_v, p_v);
    }
    break;

    case SCI_TYPE_IMAT:
    {
      sci_var_imat *p_v = static_cast<sci_var_imat *>(p_s_v->p_var);
      push(p_s_v, p_v);
    }
    break;

    case SCI_TYPE_BMAT:
    {
      sci_var_bmat *p_v = static_cast<sci_var_bmat *>(p_s_v->p_var);
      push(p_s_v, p_v);
    }
    break;

    case SCI_TYPE_CMAT:
    {
      sci_var_cmat *p_v = static_cast<sci_var_cmat *>(p_s_v->p_var);
      push(p_s_v, p_v);
    }
    break;

    default:
      throw sci_exception("pop(p_s_v) - unknown type", var_type);
      break;
  }
  // this should not ever happen
  return;
}
#else
// this could only work with RTTI - dynamic_cast<void *>
void push(struct var_struct *p_s_v)
{
  push(p_s_v, (sci_var *)(p_s_v->p_var));
}
#endif

