/*xxx
 * \brief - emulate sci syntax using sci layer and overloading
 * \to do - templates
 * \author maki
 */


// ----- SCI -----
#include "sci\_sci_if_emu.hpp"
#include "sci\_sci_if_op.hpp"


using namespace std;
using namespace itpp;
using namespace SCI;

namespace SCI
{
/// \cond EMU_DOC

// simulate a struct var_struct using double
struct var_struct   emu_var_struct(const double &v)
{
  struct var_struct s;

  s.rows = 1;
  s.cols = 1;
  s.sci_type = SCI_TYPE_DOUBLE;
  s.p_var = NULL;             // v is not var class object, use operators directly not via pop()
  emu_sci_if_malloc(&s);      // alloc external variable
  push_to_ext_stack(&s, v);   // set values of stack variable

  return (s);
}

// simulate a struct var_struct using vec
struct var_struct   emu_var_struct(const vec &v)
{
  struct var_struct s;

  s.rows = v.length();
  s.cols = 1;
  s.sci_type = SCI_TYPE_VEC;
  s.p_var = NULL;               // v is not var class object, use operators directly not via pop()
  emu_sci_if_malloc(&s);        // alloc external variable
  &s <= v;                      // copy data into the heap
  return (s);
}

// simulate a struct var_struct using mat
struct var_struct   emu_var_struct(const mat &m)
{
  struct var_struct s;

  s.rows = m.rows();
  s.cols = m.cols();
  s.sci_type = SCI_TYPE_MAT;
  s.p_var = NULL;               // v is not var class object
  emu_sci_if_malloc(&s);        // alloc external variable
  &s <= m;                      // copy data into the heap

  return (s);
}

// simulate a struct var_struct using int
struct var_struct   emu_var_struct(const int &v)
{
  struct var_struct s;

  s.rows = 1;
  s.cols = 1;
  s.sci_type = SCI_TYPE_INT;
  s.p_var = NULL;               // v is not var class object
  emu_sci_if_malloc(&s);        // alloc external variable
  push_to_ext_stack(&s, v);

  return (s);
}

// simulate a struct var_struct using ivec
struct var_struct   emu_var_struct(const ivec &v)
{
  struct var_struct s;

  s.rows = v.length();
  s.cols = 1;
  s.sci_type = SCI_TYPE_IVEC;
  s.p_var = NULL;               // v is not var class object
  emu_sci_if_malloc(&s);
  &s <= v;                      // copy data into the heap

  return (s);
}

// simulate a struct var_struct using ivec
struct var_struct   emu_var_struct(const imat &m)
{
  struct var_struct s;

  s.rows = m.rows();
  s.cols = m.cols();
  s.sci_type = SCI_TYPE_IMAT;
  s.p_var = NULL;               // v is not var class object
  emu_sci_if_malloc(&s);
  &s <= m;                      // copy data into the heap

  return (s);
}

// simulate a struct var_struct using int
struct var_struct   emu_var_struct(const bool &v)
{
  struct var_struct s;

  s.rows = 1;
  s.cols = 1;
  s.sci_type = SCI_TYPE_BOOL;
  s.p_var = NULL;               // v is not var class object
  emu_sci_if_malloc(&s);        // alloc external variable
  push_to_ext_stack(&s, v);

  return (s);
}


// simulate a struct var_struct using bvec
struct var_struct   emu_var_struct(const bvec &v)
{
  struct var_struct s;

  s.rows = v.length();
  s.cols = 1;
  s.sci_type = SCI_TYPE_BVEC;
  s.p_var = NULL;             // v is not var class object
  emu_sci_if_malloc(&s);      // alloc external variable
  &s <= v;                    // copy data into the heap

  return (s);
}

// simulate a struct var_struct using bvec
struct var_struct   emu_var_struct(const bmat &m)
{
  struct var_struct s;

  s.rows = m.rows();
  s.cols = m.cols();
  s.sci_type = SCI_TYPE_BMAT;
  s.p_var = NULL;             // v is not var class object
  emu_sci_if_malloc(&s);      // alloc external variable
  &s <= m;                    // copy data into the heap

  return (s);
}


// simulate a struct var_struct using cvec
struct var_struct   emu_var_struct(const cvec &v)
{
  struct var_struct s;

  s.rows = v.length();
  s.cols = 1;
  s.sci_type = SCI_TYPE_CVEC;
  s.p_var = NULL;             // v is not var class object
  emu_sci_if_malloc(&s);      // alloc external variable
  &s <= v;                    // copy data into the heap
  return (s);
}

// simulate a struct var_struct using int
struct var_struct   emu_var_struct(const complex<double> &v)
{
  struct var_struct s;

  s.rows = 1;
  s.cols = 1;
  s.sci_type = SCI_TYPE_COMPLEX;
  s.p_var = NULL;             // v is not var class object
  emu_sci_if_malloc(&s);      // alloc external variable
  push_to_ext_stack(&s, v);

  return (s);
}

// simulate a struct var_struct using cmat
struct var_struct   emu_var_struct(const cmat &m)
{
  struct var_struct s;

  s.rows = m.rows();
  s.cols = m.cols();
  s.sci_type = SCI_TYPE_CMAT;
  s.p_var = NULL;             // v is not var class object
  emu_sci_if_malloc(&s);      // alloc external variable
  &s <= m;                    // copy data into the heap
  return (s);
}


// no overload just keep function name conventions
void* EMU_SCI_IF_CREATE(int sci_type)
{
  return (sci_if_create(sci_type));
}

// no overload just keep function name conventions
void EMU_SCI_IF_EXEC(void *p_dev, int sci_command)
{
  return (sci_if_exec(p_dev, sci_command));
}

// no overload just keep function name conventions
void EMU_SCI_IF_DESTROY(void *p_dev)
{
  return (sci_if_destroy(p_dev));
}

/// \endcond

};
