/*xxx
* \brief - definition of scilab sci_var class and derived classes
* \author maki
*/

// ----- SCI -----
#include "sci\_sci_var.hpp"
#include "sci\_sci_exception.hpp"

using namespace SCI;

/// \cond SCI_VAR_DOC
/// this should prevent doxygen from documenting classes below

// -------------------------------------
// default
double sci_var_double::get_double()
{
  return v;
}

// available if defined(SCI_FLEX)
#if (defined(SCI_FLEX))

int sci_var_double::get_int()
{
#pragma warning(disable : 4244)
  return int(v);
}

bool sci_var_double::get_bool()
{
#pragma warning(disable : 4244 4800)
  return bool(int(v));
}

#else
int                 sci_var_double::get_int()
{
  throw sci_exception("sci_var_double::get_int() - cast not available", 0);
};
bool                sci_var_double::get_bool()
{
  throw sci_exception("sci_var_double::get_bool() - cast not available", 0);
};
#endif

complex<double>     sci_var_double::get_complex()
{
  throw sci_exception("sci_var_double::get_complex() - cast not available", 0);
};
vec                 sci_var_double::get_vec()
{
  throw sci_exception("sci_var_double::get_vec() - cast not available", 0);
};
mat                 sci_var_double::get_mat()
{
  throw sci_exception("sci_var_double::get_mat() - cast not available", 0);
};
bvec                sci_var_double::get_bvec()
{
  throw sci_exception("sci_var_double::get_bvec() - cast not available", 0);
};
bmat                sci_var_double::get_bmat()
{
  throw sci_exception("sci_var_double::get_bmat() - cast not available", 0);
};
ivec                sci_var_double::get_ivec()
{
  throw sci_exception("sci_var_double::get_ivec() - cast not available", 0);
};
imat                sci_var_double::get_imat()
{
  throw sci_exception("sci_var_double::get_imat() - cast not available", 0);
};
cvec                sci_var_double::get_cvec()
{
  throw sci_exception("sci_var_double::get_cvec() - cast not available", 0);
};
cmat                sci_var_double::get_cmat()
{
  throw sci_exception("sci_var_double::get_cmat() - cast not available", 0);
};

// -------------------------------------
// default
int sci_var_int::get_int()
{
  return v;
}

// available if defined(SCI_FLEX)
#if (defined(SCI_FLEX))

bool sci_var_int::get_bool()
{
#pragma warning(disable : 4244 4800)
  return bool(v);
}

#else
bool                sci_var_int::get_bool()
{
  throw sci_exception("sci_var_int::get_bool() - cast not available", 0);
};
#endif

double              sci_var_int::get_double()
{
  throw sci_exception("sci_var_int::get_double() - cast not available", 0);
};
complex<double>     sci_var_int::get_complex()
{
  throw sci_exception("sci_var_int::get_complex() - cast not available", 0);
};

vec                 sci_var_int::get_vec()
{
  throw sci_exception("sci_var_int::get_vec() - cast not available", 0);
};
mat                 sci_var_int::get_mat()
{
  throw sci_exception("sci_var_int::get_mat() - cast not available", 0);
};
bvec                sci_var_int::get_bvec()
{
  throw sci_exception("sci_var_int::get_bvec() - cast not available", 0);
};
bmat                sci_var_int::get_bmat()
{
  throw sci_exception("sci_var_int::get_bmat() - cast not available", 0);
};
ivec                sci_var_int::get_ivec()
{
  throw sci_exception("sci_var_int::get_ivec() - cast not available", 0);
};
imat                sci_var_int::get_imat()
{
  throw sci_exception("sci_var_int::get_imat() - cast not available", 0);
};
cvec                sci_var_int::get_cvec()
{
  throw sci_exception("sci_var_int::get_cvec() - cast not available", 0);
};
cmat                sci_var_int::get_cmat()
{
  throw sci_exception("sci_var_int::get_cmat() - cast not available", 0);
};

// -------------------------------------
// default
bool sci_var_bool::get_bool()
{
  return v;
}

double              sci_var_bool::get_double()
{
  throw sci_exception("sci_var_bool::get_double() - cast not available", 0);
};
int                 sci_var_bool::get_int()
{
  throw sci_exception("sci_var_bool::get_int() - cast not available", 0);
};
complex<double>     sci_var_bool::get_complex()
{
  throw sci_exception("sci_var_bool::get_complex() - cast not available", 0);
};

vec                 sci_var_bool::get_vec()
{
  throw sci_exception("sci_var_bool::get_vec() - cast not available", 0);
};
mat                 sci_var_bool::get_mat()
{
  throw sci_exception("sci_var_bool::get_mat() - cast not available", 0);
};
bvec                sci_var_bool::get_bvec()
{
  throw sci_exception("sci_var_bool::get_bvec() - cast not available", 0);
};
bmat                sci_var_bool::get_bmat()
{
  throw sci_exception("sci_var_bool::get_bmat() - cast not available", 0);
};
ivec                sci_var_bool::get_ivec()
{
  throw sci_exception("sci_var_bool::get_ivec() - cast not available", 0);
};
imat                sci_var_bool::get_imat()
{
  throw sci_exception("sci_var_bool::get_imat() - cast not available", 0);
};
cvec                sci_var_bool::get_cvec()
{
  throw sci_exception("sci_var_bool::get_cvec() - cast not available", 0);
};
cmat                sci_var_bool::get_cmat()
{
  throw sci_exception("sci_var_bool::get_cmat() - cast not available", 0);
};

// -------------------------------------
// default
complex<double> sci_var_complex::get_complex()
{
  return v;
}

double              sci_var_complex::get_double()
{
  throw sci_exception("sci_var_complex::get_double() - cast not available", 0);
};
int                 sci_var_complex::get_int()
{
  throw sci_exception("sci_var_complex::get_int() - cast not available", 0);
};
bool                sci_var_complex::get_bool()
{
  throw sci_exception("sci_var_complex::get_bool() - cast not available", 0);
};

vec                 sci_var_complex::get_vec()
{
  throw sci_exception("sci_var_complex::get_vec() - cast not available", 0);
};
mat                 sci_var_complex::get_mat()
{
  throw sci_exception("sci_var_complex::get_mat() - cast not available", 0);
};
bvec                sci_var_complex::get_bvec()
{
  throw sci_exception("sci_var_complex::get_bvec() - cast not available", 0);
};
bmat                sci_var_complex::get_bmat()
{
  throw sci_exception("sci_var_complex::get_bmat() - cast not available", 0);
};
ivec                sci_var_complex::get_ivec()
{
  throw sci_exception("sci_var_complex::get_ivec() - cast not available", 0);
};
imat                sci_var_complex::get_imat()
{
  throw sci_exception("sci_var_complex::get_imat() - cast not available", 0);
};
cvec                sci_var_complex::get_cvec()
{
  throw sci_exception("sci_var_complex::get_cvec() - cast not available", 0);
};
cmat                sci_var_complex::get_cmat()
{
  throw sci_exception("sci_var_complex::get_cmat() - cast not available", 0);
};


// -------------------------------------
// default
double sci_var_vec::get_double()
{
  if(v.length() == 1)
  {
    return v(0);
  }
  else
  {
    throw sci_exception("sci_var_vec::get_double() - bad vec length", v.length());
  }
}

vec sci_var_vec::get_vec()
{
  return v;
}

// available if defined(SCI_FLEX)
#if (defined(SCI_FLEX))

ivec sci_var_vec::get_ivec()
{
  return to_ivec(v);
}

bvec sci_var_vec::get_bvec()
{
#pragma warning(disable : 4244)
  return to_bvec(v);
}

int sci_var_vec::get_int()
{
  if(v.length() == 1)
  {
    return int(v(0));
  }
  else
  {
    throw sci_exception("sci_var_vec::get_int() - bad vec length", v.length());
  }
}

#pragma warning(disable : 4800)
bool sci_var_vec::get_bool()
{
  if(v.length() == 1)
  {
    return bool(int(v(0)));
  }
  else
  {
    throw sci_exception("sci_var_vec::get_bool() - bad vec length", v.length());
  }
}
#else

bool                sci_var_vec::get_bool()
{
  throw sci_exception("sci_var_vec::get_bool() - cast not available", 0);
};
bvec                sci_var_vec::get_bvec()
{
  throw sci_exception("sci_var_vec::get_bvec() - cast not available", 0);
};
int                 sci_var_vec::get_int()
{
  throw sci_exception("sci_var_vec::get_int() - cast not available", 0);
};
ivec                sci_var_vec::get_ivec()
{
  throw sci_exception("sci_var_vec::get_ivec() - cast not available", 0);
};

#endif

// not available
mat                 sci_var_vec::get_mat()
{
  throw sci_exception("sci_var_vec::get_mat() - cast not available", 0);
};
imat                sci_var_vec::get_imat()
{
  throw sci_exception("sci_var_vec::get_imat() - cast not available", 0);
};
bmat                sci_var_vec::get_bmat()
{
  throw sci_exception("sci_var_vec::get_bmat() - cast not available", 0);
};
complex<double>     sci_var_vec::get_complex()
{
  throw sci_exception("sci_var_vec::get_complex() - cast not available", 0);
};
cvec                sci_var_vec::get_cvec()
{
  throw sci_exception("sci_var_vec::get_cvec() - cast not available", 0);
};
cmat                sci_var_vec::get_cmat()
{
  throw sci_exception("sci_var_vec::get_cmat() - cast not available", 0);
};

// -------------------------------------
// -------------------------------------
// default
double sci_var_mat::get_double()
{
  if((v.rows() == 1) && (v.cols() == 1))
  {
    return v(0, 0);
  }
  else
  {
    throw sci_exception("sci_var_mat::get_double() - bad mat size", 0);
  }
}

vec sci_var_mat::get_vec()
{
  if(v.rows() == 1)
  {
    return v.get_row(0);
  }
  else if(v.cols() == 1)
  {
    return v.get_col(0);
  }
  else
  {
    throw sci_exception("sci_var_mat::get_vec() - bad mat size", 0);
  }
}

mat sci_var_mat::get_mat()
{
  return v;
}

// available if defined(SCI_FLEX)
#if (defined(SCI_FLEX))

ivec sci_var_mat::get_ivec()
{
  if(v.rows() == 1)
  {
    return to_ivec(v.get_row(0));
  }
  else if(v.cols() == 1)
  {
    return to_ivec(v.get_col(0));
  }
  else
  {
    throw sci_exception("sci_var_mat::get_ivec() - bad mat size", 0);
  }
}

bvec sci_var_mat::get_bvec()
{
  if(v.rows() == 1)
  {
    return to_bvec(v.get_row(0));
  }
  else if(v.cols() == 1)
  {
    return to_bvec(v.get_col(0));
  }
  else
  {
    throw sci_exception("sci_var_mat::get_bvec() - bad mat size", 0);
  }
}

imat sci_var_mat::get_imat()
{
  return to_imat(v);
}

bmat sci_var_mat::get_bmat()
{
#pragma warning(disable : 4244)
  return to_bmat(v);
}

int sci_var_mat::get_int()
{
  if((v.rows() == 1) && (v.cols() == 1))
  {
    return int(v(0, 0));
  }
  else
  {
    throw sci_exception("sci_var_mat::get_int() - bad mat size", 0);
  }
}

#pragma warning(disable : 4800)
bool sci_var_mat::get_bool()
{
  if((v.rows() == 1) && (v.cols() == 1))
  {
    return bool(int(v(0, 0)));
  }
  else
  {
    throw sci_exception("sci_var_mat::get_bool() - bad mat size", 0);
  }
}

#else

bool                sci_var_mat::get_bool()
{
  throw sci_exception("sci_var_mat::get_bool() - cast not available", 0);
};
bvec                sci_var_mat::get_bvec()
{
  throw sci_exception("sci_var_mat::get_bvec() - cast not available", 0);
};
bmat                sci_var_mat::get_bmat()
{
  throw sci_exception("sci_var_mat::get_bmat() - cast not available", 0);
};
int                 sci_var_mat::get_int()
{
  throw sci_exception("sci_var_mat::get_int() - cast not available", 0);
};
ivec                sci_var_mat::get_ivec()
{
  throw sci_exception("sci_var_mat::get_ivec() - cast not available", 0);
};
imat                sci_var_mat::get_imat()
{
  throw sci_exception("sci_var_mat::get_imat() - cast not available", 0);
};

#endif

// not available
complex<double>     sci_var_mat::get_complex()
{
  throw sci_exception("sci_var_mat::get_complex() - cast not available", 0);
};
cvec                sci_var_mat::get_cvec()
{
  throw sci_exception("sci_var_mat::get_cvec() - cast not available", 0);
};
cmat                sci_var_mat::get_cmat()
{
  throw sci_exception("sci_var_mat::get_cmat() - cast not available", 0);
};

// -------------------------------------
// -------------------------------------
// default
int sci_var_ivec::get_int()
{
  if(v.length() == 1)
  {
    return v(0);
  }
  else
  {
    throw sci_exception("sci_var_ivec::get_int() - bad vec length", v.length());
  }
}

ivec sci_var_ivec::get_ivec()
{
  return v;
}

// available if defined(SCI_FLEX)
#if (defined(SCI_FLEX))

bool sci_var_ivec::get_bool()
{
  if(v.length() == 1)
  {
    return bool(v(0));
  }
  else
  {
    throw sci_exception("sci_var_ivec::get_bool() - bad vec length", v.length());
  }
}
bvec sci_var_ivec::get_bvec()
{
  return to_bvec(v);
}

#else

bool                sci_var_ivec::get_bool()
{
  throw sci_exception("sci_var_imat::get_bool() - cast not available", 0);
};
bvec                sci_var_ivec::get_bvec()
{
  throw sci_exception("sci_var_imat::get_bvec() - cast not available", 0);
};

#endif
// not available
bmat                sci_var_ivec::get_bmat()
{
  throw sci_exception("sci_var_ivec::get_bmat() - cast not available", 0);
};
imat                sci_var_ivec::get_imat()
{
  throw sci_exception("sci_var_ivec::get_imat() - cast not available", 0);
};
double              sci_var_ivec::get_double()
{
  throw sci_exception("sci_var_ivec::get_double() - cast not available", 0);
};
vec                 sci_var_ivec::get_vec()
{
  throw sci_exception("sci_var_ivec::get_vec() - cast not available", 0);
};
mat                 sci_var_ivec::get_mat()
{
  throw sci_exception("sci_var_ivec::get_mat() - cast not available", 0);
};
complex<double>     sci_var_ivec::get_complex()
{
  throw sci_exception("sci_var_ivec::get_complex() - cast not available", 0);
};
cvec                sci_var_ivec::get_cvec()
{
  throw sci_exception("sci_var_ivec::get_cvec() - cast not available", 0);
};
cmat                sci_var_ivec::get_cmat()
{
  throw sci_exception("sci_var_ivec::get_cmat() - cast not available", 0);
};

// -------------------------------------
// -------------------------------------
// default
int sci_var_imat::get_int()
{
  if((v.rows() == 1) && (v.cols() == 1))
  {
    return v(0, 0);
  }
  else
  {
    throw sci_exception("sci_var_imat::get_int() - bad mat size", 0);
  }
}

ivec sci_var_imat::get_ivec()
{
  if(v.rows() == 1)
  {
    return v.get_row(0);
  }
  else if(v.cols() == 1)
  {
    return v.get_col(0);
  }
  else
  {
    throw sci_exception("sci_var_imat::get_ivec() - bad mat size", 0);
  }
}

imat sci_var_imat::get_imat()
{
  return v;
}

// available if defined(SCI_FLEX)
#if (defined(SCI_FLEX))

#pragma warning(disable : 4800)
bool sci_var_imat::get_bool()
{
  if((v.rows() == 1) && (v.cols() == 1))
  {
    return bool(v(0, 0));
  }
  else
  {
    throw sci_exception("sci_var_imat::get_bool() - bad mat size", 0);
  }
}

bvec sci_var_imat::get_bvec()
{
  if(v.rows() == 1)
  {
    return to_bvec(v.get_row(0));
  }
  else if(v.cols() == 1)
  {
    return to_bvec(v.get_col(0));
  }
  else
  {
    throw sci_exception("sci_var_imat::get_bvec() - bad mat size", 0);
  }
}

bmat sci_var_imat::get_bmat()
{
  return to_bmat(v);
}

#else

bool                sci_var_imat::get_bool()
{
  throw sci_exception("sci_var_imat::get_bool() - cast not available", 0);
};
bvec                sci_var_imat::get_bvec()
{
  throw sci_exception("sci_var_imat::get_bvec() - cast not available", 0);
};
bmat                sci_var_imat::get_bmat()
{
  throw sci_exception("sci_var_imat::get_bmat() - cast not available", 0);
};

#endif

// not available
double              sci_var_imat::get_double()
{
  throw sci_exception("sci_var_imat::get_double() - cast not available", 0);
};
vec                 sci_var_imat::get_vec()
{
  throw sci_exception("sci_var_imat::get_vec() - cast not available", 0);
};
mat                 sci_var_imat::get_mat()
{
  throw sci_exception("sci_var_imat::get_mat() - cast not available", 0);
};
complex<double>     sci_var_imat::get_complex()
{
  throw sci_exception("sci_var_imat::get_complex() - cast not available", 0);
};
cvec                sci_var_imat::get_cvec()
{
  throw sci_exception("sci_var_imat::get_cvec() - cast not available", 0);
};
cmat                sci_var_imat::get_cmat()
{
  throw sci_exception("sci_var_imat::get_cmat() - cast not available", 0);
};

// -------------------------------------
// -------------------------------------
// default
bool sci_var_bvec::get_bool()
{
  if(v.length() == 1)
  {
    return v(0);
  }
  else
  {
    throw sci_exception("sci_var_bvec::get_bool() - bad vec length", v.length());
  }
}

bvec sci_var_bvec::get_bvec()
{
  return v;
}

// not available
bmat                sci_var_bvec::get_bmat()
{
  throw sci_exception("sci_var_bvec::get_bmat() - cast not available", 0);
};
int                 sci_var_bvec::get_int()
{
  throw sci_exception("sci_var_bvec::get_int() - cast not available", 0);
};
ivec                sci_var_bvec::get_ivec()
{
  throw sci_exception("sci_var_bvec::get_ivec() - cast not available", 0);
};
imat                sci_var_bvec::get_imat()
{
  throw sci_exception("sci_var_bvec::get_imat() - cast not available", 0);
};
double              sci_var_bvec::get_double()
{
  throw sci_exception("sci_var_bvec::get_double() - cast not available", 0);
};
vec                 sci_var_bvec::get_vec()
{
  throw sci_exception("sci_var_bvec::get_vec() - cast not available", 0);
};
mat                 sci_var_bvec::get_mat()
{
  throw sci_exception("sci_var_bvec::get_mat() - cast not available", 0);
};
complex<double>     sci_var_bvec::get_complex()
{
  throw sci_exception("sci_var_bvec::get_complex() - cast not available", 0);
};
cvec                sci_var_bvec::get_cvec()
{
  throw sci_exception("sci_var_bvec::get_cvec() - cast not available", 0);
};
cmat                sci_var_bvec::get_cmat()
{
  throw sci_exception("sci_var_bvec::get_cmat() - cast not available", 0);
};

// -------------------------------------
// -------------------------------------
// default

bool sci_var_bmat::get_bool()
{
  if((v.rows() == 1) && (v.cols() == 1))
  {
    return v(0, 0);
  }
  else
  {
    throw sci_exception("sci_var_bmat::get_bool() - bad mat size", 0);
  }
}

bvec sci_var_bmat::get_bvec()
{
  if(v.rows() == 1)
  {
    return v.get_row(0);
  }
  else if(v.cols() == 1)
  {
    return v.get_col(0);
  }
  else
  {
    throw sci_exception("sci_var_bmat::get_bvec() - bad mat size", 0);
  }
}

bmat sci_var_bmat::get_bmat()
{
  return v;
}

// not available
int                 sci_var_bmat::get_int()
{
  throw sci_exception("sci_var_bmat::get_int() - cast not available", 0);
};
ivec                sci_var_bmat::get_ivec()
{
  throw sci_exception("sci_var_bmat::get_ivec() - cast not available", 0);
};
imat                sci_var_bmat::get_imat()
{
  throw sci_exception("sci_var_bmat::get_imat() - cast not available", 0);
};
double              sci_var_bmat::get_double()
{
  throw sci_exception("sci_var_bmat::get_double() - cast not available", 0);
};
vec                 sci_var_bmat::get_vec()
{
  throw sci_exception("sci_var_bmat::get_vec() - cast not available", 0);
};
mat                 sci_var_bmat::get_mat()
{
  throw sci_exception("sci_var_bmat::get_mat() - cast not available", 0);
};
complex<double>     sci_var_bmat::get_complex()
{
  throw sci_exception("sci_var_bmat::get_complex() - cast not available", 0);
};
cvec                sci_var_bmat::get_cvec()
{
  throw sci_exception("sci_var_bmat::get_cvec() - cast not available", 0);
};
cmat                sci_var_bmat::get_cmat()
{
  throw sci_exception("sci_var_bmat::get_cmat() - cast not available", 0);
};

// -------------------------------------
// -------------------------------------
// default
complex<double> sci_var_cvec::get_complex()
{
  if(v.length() == 1)
  {
    return v(0);
  }
  else
  {
    throw sci_exception("sci_var_cvec::get_complex() - bad vec length", v.length());
  }
}

cvec sci_var_cvec::get_cvec()
{
  return v;
}

// not available
cmat                sci_var_cvec::get_cmat()
{
  throw sci_exception("sci_var_cvec::get_cmat() - cast not available", 0);
};
bool                sci_var_cvec::get_bool()
{
  throw sci_exception("sci_var_cvec::get_bool() - cast not available", 0);
};
bvec                sci_var_cvec::get_bvec()
{
  throw sci_exception("sci_var_cvec::get_bvec() - cast not available", 0);
};
bmat                sci_var_cvec::get_bmat()
{
  throw sci_exception("sci_var_cvec::get_bmat() - cast not available", 0);
};
int                 sci_var_cvec::get_int()
{
  throw sci_exception("sci_var_cvec::get_int() - cast not available", 0);
};
ivec                sci_var_cvec::get_ivec()
{
  throw sci_exception("sci_var_cvec::get_ivec() - cast not available", 0);
};
imat                sci_var_cvec::get_imat()
{
  throw sci_exception("sci_var_cvec::get_imat() - cast not available", 0);
};
double              sci_var_cvec::get_double()
{
  throw sci_exception("sci_var_cvec::get_double() - cast not available", 0);
};
vec                 sci_var_cvec::get_vec()
{
  throw sci_exception("sci_var_cvec::get_vec() - cast not available", 0);
};
mat                 sci_var_cvec::get_mat()
{
  throw sci_exception("sci_var_cvec::get_mat() - cast not available", 0);
};

// -------------------------------------
// default
complex<double> sci_var_cmat::get_complex()
{
  if((v.rows() == 1) && (v.cols() == 1))
  {
    return v(0, 0);
  }
  else
  {
    throw sci_exception("sci_var_cmat::get_complex() - bad mat size", 0);
  }
}

cvec sci_var_cmat::get_cvec()
{
  if(v.rows() == 1)
  {
    return v.get_row(0);
  }
  else if(v.cols() == 1)
  {
    return v.get_col(0);
  }
  else
  {
    throw sci_exception("sci_var_cmat::get_cvec() - bad mat size", 0);
  }
}

cmat sci_var_cmat::get_cmat()
{
  return v;
}

// not available
bool                sci_var_cmat::get_bool()
{
  throw sci_exception("sci_var_cmat::get_bool() - cast not available", 0);
};
bvec                sci_var_cmat::get_bvec()
{
  throw sci_exception("sci_var_cmat::get_bvec() - cast not available", 0);
};
bmat                sci_var_cmat::get_bmat()
{
  throw sci_exception("sci_var_cmat::get_bmat() - cast not available", 0);
};
int                 sci_var_cmat::get_int()
{
  throw sci_exception("sci_var_cmat::get_int() - cast not available", 0);
};
ivec                sci_var_cmat::get_ivec()
{
  throw sci_exception("sci_var_cmat::get_ivec() - cast not available", 0);
};
imat                sci_var_cmat::get_imat()
{
  throw sci_exception("sci_var_cmat::get_imat() - cast not available", 0);
};
double              sci_var_cmat::get_double()
{
  throw sci_exception("sci_var_cmat::get_double() - cast not available", 0);
};
vec                 sci_var_cmat::get_vec()
{
  throw sci_exception("sci_var_cmat::get_vec() - cast not available", 0);
};
mat                 sci_var_cmat::get_mat()
{
  throw sci_exception("sci_var_cmat::get_mat() - cast not available", 0);
};

// -------------------------------------
/// end of condition preventing doxygen from documenting classes
/// \endcond

