/*xxx
* \brief - returns  real/complex vectors read from file
* \author maki
*/

#include "file_vec.hpp"


//! \brief works for vec - i.e. double
vec file_read_vec(const char* filename)
{
// Assumes coefficients are real.
  int i = 0;
  double tmp;
  int num_taps = 0;
  vec v;
  streampos start_here;

  ifstream firf(filename);
  if(!firf)
  {
    cout << "Could not open file " << filename << "\n";
    return(v); // null if error
  }
  // start_here = firf.tellg();
  while(!firf.eof())
  {
    firf >>	tmp;
    if(firf.good()) num_taps++;
  }
  firf.close();
  // firf.seekg( start_here );
  firf.clear();
  v.set_size(num_taps);
  firf.open(filename);
  i = 0;
  while((!firf.eof()) && (i < num_taps))
  {
    firf >> tmp;
    if(firf.good()) v[i++] = tmp;
  }
  firf.close();
  return(v);
}

//!  \brief works for cvec - i.e. double
cvec file_read_cvec(const char* filename)
{
// Assumes coefficients are complex.
  int i = 0;
  double tmp;
  double tmpi, tmpr;
  int num_taps = 0;
  cvec cv;
  ifstream firf(filename);

  if(!firf)
  {
    cout << "Could not open file " << filename << "\n";
    return(cv); // null if error
  }
  while(!firf.eof())
  {
    firf >>	tmp;
    firf >> tmp;
    if(firf.good()) num_taps++;
  }
  firf.close();
  cv.set_size(num_taps);
  firf.open(filename);
  firf.clear();
  i = 0;
  while(!firf.eof()  && (i < num_taps))
  {
    firf >> tmpr;
    firf >> tmpi;
    if(firf.good()) cv[i++] = complex<double>(tmpr, tmpi);
  }
  firf.close();

  return(cv);
}


