/*xxx
* \brief - sci_amp, sci_amp_x test application
* \author maki
*/

// ----MSVC----
#include <iostream>
#include <fstream>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ---- SIM  ----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_amp_x()
{

#ifdef _SCI_
  sci_base	*p_g1, *p_g_x1, *p_wgn1, *p_wgn_x1;  
#else
  void    	*p_g1, *p_g_x1, *p_wgn1, *p_wgn_x1;
#endif

  const int N = 10;      // sequence lenght
  const double g1_gain = 1.1;
  const double g1_offset = 0.1;
  const complexd g_x1_gain = complexd(1.15, 1.25);
  const complexd g_x1_offset = complexd(0.15, 0.25);

  bvec ce;
  vec  x1, y1, y1_ref;
  cvec x_x1, y_x1, y_x1_ref;

  int err = 0;
  int sci_type;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_amp_x" << endl;
  try
  {
    p_wgn1 = SCI_CREATE(SCI_WGN); 
    p_wgn_x1 = SCI_CREATE(SCI_WGN_X);

    p_g1 = SCI_CREATE(SCI_AMP);
    sci_type = SCI_GET<int>(p_g1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_AMP, "sci_type != SCI_AMP");
    
    SCI_SET(p_g1, SCI_GAIN, g1_gain);
    SCI_SET(p_g1, SCI_OFFSET, g1_offset);
    
    debug(1) << "g1.gain =" << SCI_GET<double>(p_g1, SCI_GAIN) << endl;
    debug(1) << "g1.offset =" << SCI_GET<double>(p_g1, SCI_OFFSET) << endl;
    
    itpp_sci_assert(SCI_GET<double>(p_g1, SCI_GAIN) == g1_gain, "g1.get_gain() != g1_gain");
    itpp_sci_assert(SCI_GET<double>(p_g1, SCI_OFFSET) == g1_offset, "g1.get_offset() != g1_offset");

    p_g_x1 = SCI_CREATE(SCI_AMP_X);
    sci_type = SCI_GET<int>(p_g_x1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_AMP_X, "sci_type != SCI_AMP_X");

    SCI_SET(p_g_x1, SCI_GAIN, g_x1_gain);
    SCI_SET(p_g_x1, SCI_OFFSET, g_x1_offset);

    debug(1) << "g_x1.gain =" << SCI_GET<complexd>(p_g_x1, SCI_GAIN) << endl;
    debug(1) << "g_x1.offset =" << SCI_GET<complexd>(p_g_x1, SCI_OFFSET) << endl;

    itpp_sci_assert(SCI_GET<complexd>(p_g_x1, SCI_GAIN) == g_x1_gain, "g_x1.get_gain() != g_x1_gain");
    itpp_sci_assert(SCI_GET<complexd>(p_g_x1, SCI_OFFSET) == g_x1_offset, "g_x1.get_offset() != g_x1_offset");

    ce.set_length(N);
    ce.ones();

    x1 = SCI_GEN<vec>(p_wgn1, ce);
    x_x1 = SCI_GEN<cvec>(p_wgn_x1, ce);

    y1 = SCI_PROC<vec>(p_g1, ce, x1);

    y1_ref = g1_gain*x1 + g1_offset;
    debug(3) << "    x1 =" << x1 << endl;
    debug(3) << "    y1 = " << y1 << endl;
    debug(3) << "y1_ref = " << y1_ref << endl;

    y_x1 = SCI_PROC<cvec>(p_g_x1, ce, x_x1);
    y_x1_ref = g_x1_gain*x_x1 + g_x1_offset;

    debug(3) << "    x_x1 =" << x_x1 << endl;
    debug(3) << "    y_x1 = " << y_x1 << endl;
    debug(3) << "y_x1_ref = " << y_x1_ref << endl;

    itpp_sci_assert(y1 == y1_ref, "y1 != y1_ref");
    itpp_sci_assert(y_x1 == y_x1_ref, "y_x1 != y_x1_ref");

    SCI_DESTROY(p_wgn1);
    SCI_DESTROY(p_wgn_x1);
    SCI_DESTROY(p_g1);
    SCI_DESTROY(p_g_x1);

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
