/*!
* \brief - sci_bit2int, sci_int2bit test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>

// ---- ITPP  ----

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_bin2int()
{

#ifdef _SCI_
  sci_base *p_b2i1, *p_i2b1;
#else
  void *p_b2i1, *p_i2b1;
#endif

  const int N = 16;
  const int W = 4;
  int i;
  bvec ce;
  bmat y1, y1_ref;
  ivec x1, y2;
  int err = 0;
  int sci_type;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_bin2int" << endl;
  try
  {
    ce.set_length(N);
    ce.ones();
    cout << "ce =" << ce << endl;

    x1.set_length(N);
    for(i = 0; i < N; i++)
    {
      x1[i] = i;
    }
    cout << "x =" << x1 << endl;

    p_i2b1 = SCI_CREATE(SCI_INT2BIN);
    sci_type = SCI_GET<int>(p_i2b1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_INT2BIN, "sci_type != SCI_INT2BIN");

    p_b2i1 = SCI_CREATE(SCI_BIN2INT);
    sci_type = SCI_GET<int>(p_b2i1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_BIN2INT, "sci_type != SCI_BIN2INT");

    SCI_SET(p_i2b1, SCI_SYMBOL_SIZE, W);
    SCI_SET(p_b2i1, SCI_SYMBOL_SIZE, W);

    itpp_sci_assert(W == SCI_GET<int>(p_i2b1, SCI_SYMBOL_SIZE), "W != SCI_GET(p_i2b1, SCI_SYMBOL_SIZE)");
    itpp_sci_assert(W == SCI_GET<int>(p_b2i1, SCI_SYMBOL_SIZE), "W != SCI_GET(p_b2i1, SCI_SYMBOL_SIZE)");
    itpp_sci_assert(SCI_GET<bool>(p_i2b1, SCI_MSB_FLAG), "true != SCI_GET(p_i2b1, SCI_MSB_FLAG)");
    itpp_sci_assert(SCI_GET<bool>(p_b2i1, SCI_MSB_FLAG), "true != SCI_GET(p_b2i1, SCI_MSB_FLAG)");

    y1_ref = bmat("0 0 0 0; 0 0 0 1; 0 0 1 0; 0 0 1 1; 0 1 0 0; 0 1 0 1; 0 1 1 0; 0 1 1 1;\
                     1 0 0 0; 1 0 0 1; 1 0 1 0; 1 0 1 1; 1 1 0 0; 1 1 0 1; 1 1 1 0; 1 1 1 1");

    y1 = SCI_PROC<bmat>(p_i2b1, ce, x1);
    cout << "y1 = \n" << y1 << endl;
    itpp_sci_assert(y1 == y1_ref, "y1 != y1_ref");

    y2 = SCI_PROC<ivec>(p_b2i1, ce, y1);
    cout << "y2 =" << y2 << endl;
    itpp_sci_assert(y2 == x1, "y2 != x1");

    SCI_SET(p_i2b1, SCI_MSB_FLAG, false);
    SCI_SET(p_b2i1, SCI_MSB_FLAG, false);
    itpp_sci_assert(!SCI_GET<bool>(p_i2b1, SCI_MSB_FLAG), "true = SCI_GET(p_i2b1, SCI_MSB_FLAG)");
    itpp_sci_assert(!SCI_GET<bool>(p_b2i1, SCI_MSB_FLAG), "true = SCI_GET(p_b2i1, SCI_MSB_FLAG)");
    itpp_sci_assert(W == SCI_GET<int>(p_i2b1, SCI_SYMBOL_SIZE), "W != SCI_GET(p_i2b1, SCI_SYMBOL_SIZE)");
    itpp_sci_assert(W == SCI_GET<int>(p_b2i1, SCI_SYMBOL_SIZE), "W != SCI_GET(p_b2i1, SCI_SYMBOL_SIZE)");

    for(i = 0; i < N; i++)
    {
      y1_ref.set_row(i, reverse(y1_ref.get_row(i)));
    }

    y1 = SCI_PROC<bmat>(p_i2b1, ce, x1);
    cout << "y1 = \n" << y1 << endl;
    itpp_sci_assert(y1 == y1_ref, "y1 != y1_ref");

    y2 = SCI_PROC<ivec>(p_b2i1, ce, y1);
    cout << "y2 =" << y2 << endl;
    itpp_sci_assert(y2 == x1, "y2 != x1");

    SCI_DESTROY(p_i2b1);
    SCI_DESTROY(p_b2i1);
  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
