/*!
* \brief - sci_binbuff
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <iomanip>

#include "itpp/itbase.h"

// ---- SIM  ----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_binbuff()
{

#ifdef _SCI_
  sci_base *p_bb1;
#else
  void *p_bb1;
#endif

  const int W = 8;   // input symbols width = bytes 
  const int N = 4;   // number of input symbols

  const int WA = 4;   // testA output symbols width 
  const int WB = 16;  // testB output symbols width

  const int NA = int((N * W) / WA);       // process NA symbols of WA width
  const int NB = int((2 * N * W) / WB);   // generate NB symbols of WB width

  bvec ce, ce0, ce1;
  bmat ceio, yA, yB;

  // 4 bytes 
  const bmat     x1 = bmat("1 1 1 1 0 0 0 0; 1 1 1 1 0 0 0 1; 1 1 1 1 0 0 1 0; 1 1 1 1 0 0 1 1");
  // 8  4bit symbols
  const bmat yA_ref = bmat("1 1 1 1; 0 0 0 0; 1 1 1 1; 0 0 0 1; 1 1 1 1; 0 0 1 0; 1 1 1 1; 0 0 1 1");
  // 4  16bit symbols
  const bmat yB_ref = bmat("1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1; 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 1;\
                                                       1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1; 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 1");
  int err = 0;
  int sci_type;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_binbuff" << endl;
  try
  {
    ce.set_length(N);
    ce.ones();

    debug(1) << "x1 = " << endl << x1 << endl;

    p_bb1 = SCI_CREATE(SCI_BINBUFF);
    sci_type = SCI_GET<int>(p_bb1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_BINBUFF, "sci_type != SCI_BINBUFF");

    // buffer size in bits
    SCI_SET(p_bb1, SCI_SIZE, W * N);
    // symbols symbol_size
    SCI_SET(p_bb1, SCI_SYMBOL_SIZE, W);

    //[ceio]=[1|0]
    // ceio for binbuuf
    ce1 = to_bvec(to_ivec(ones(N)));
    ce0 = to_bvec(to_ivec(zeros(N)));
    // push in all N bytes - ceio=[cei|cei] = [1|0] - filling -up - ceo=0
    ceio.set_size(N, 2);
    ceio.set_col(0, ce1);
    ceio.set_col(1, ce0);
    SCI_PROC<bmat>(p_bb1, ceio, x1);
    debug(1) << "nrof_elements =" << SCI_GET<int>(p_bb1, SCI_N_OF_ELEM) << endl;
    itpp_sci_assert(SCI_GET<int>(p_bb1, SCI_N_OF_ELEM) == N*W, "nrof_elements() != N*W");

    // pop in all NA symbols of WA width by processing with cei=0 - empting the buffer 
    // ceio[NA,:]=[0,1]
    ce1 = to_bvec(to_ivec(ones(NA)));
    ce0 = to_bvec(to_ivec(zeros(NA)));
    ceio.set_size(NA, 2);
    ceio.set_col(0, ce0);
    ceio.set_col(1, ce1);
    // symbols new symbol_size -  convert all bits into new symbols
    SCI_SET(p_bb1, SCI_SYMBOL_SIZE, WA);
    yA = SCI_PROC<bmat>(p_bb1, ceio, ceio); ;
    debug(1) << "yA =" << endl << yA << endl;

    itpp_sci_assert(yA == yA_ref, "yA != yA_ref");

    debug(1) << "nrof_elements =" << SCI_GET<int>(p_bb1, SCI_N_OF_ELEM) << endl;
    itpp_sci_assert(SCI_GET<int>(p_bb1, SCI_N_OF_ELEM) == 0, "nrof_elements() != 0");


    // put resized data - generate new symbols
    ce1 = to_bvec(to_ivec(ones(NB)));
    SCI_SET(p_bb1, SCI_VEC, rvectorize(x1));
    debug(1) << "nrof_elements =" << SCI_GET<int>(p_bb1, SCI_N_OF_ELEM) << endl;
    itpp_sci_assert(SCI_GET<int>(p_bb1, SCI_N_OF_ELEM) == N*W, "nrof_elements() != N*W");

    SCI_SET(p_bb1, SCI_SYMBOL_SIZE, WB);
    yB = SCI_GEN<bmat>(p_bb1, ce1);
    debug(1) << "yB =" << endl << yB << endl;
    itpp_sci_assert(yB == yB_ref, "yB != yB_ref");
    debug(1) << "nrof_elements =" << SCI_GET<int>(p_bb1, SCI_N_OF_ELEM) << endl;
    itpp_sci_assert(SCI_GET<int>(p_bb1, SCI_N_OF_ELEM) == N*W, "nrof_elements() != N*W");

    SCI_DESTROY(p_bb1);
  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
