/*xxx
* \brief - casdec_x test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <complex>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ---- SIM  ----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_casdec_x()
{

#ifdef _SCI_
  sci_base	*p_fir_x1, *p_fir_x2, *p_fir_x3;
  sci_base	*p_cnt1, *p_cnt2, *p_cnt3;
  sci_base   *p_wgn_x1;
  sci_base   *p_casdec_x1;
#else
  void		*p_fir_x1, *p_fir_x2, *p_fir_x3;
  void		*p_cnt1, *p_cnt2, *p_cnt3;
  void		*p_wgn_x1;
  void		*p_casdec_x1;
#endif

  // mav<4>
  const cvec c0 = cvec("0.25+0.0i, 0.25+0.0i, 0.25+0.0i, 0.25+0.0i");
  const int N = 5 * c0.length();
  int  CAS_DEC_ORDER = pow2i(3);

  cvec x_x;
  bvec ce, ce1, ce2, ce3, true_vec;
  cvec ya_x1, ya_x2, ya_x3;
  cmat ya, yb, yc;

  double epsilon = 1.0E-6;
  int sci_type;
  int err = 0;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_casdec_x" << endl;
  try
  {
    cout << fixed << setw(6) << setprecision(3);
    debug(1) << "CAS_DEC_ORDER = " << CAS_DEC_ORDER << endl;
    debug(1) << "c0 = " << c0 << endl;
    debug(1) << "N = " << N << endl;

    true_vec = ones_b(N);
    // clock and signal
    ce = ones_b(N);

    p_casdec_x1 = SCI_CREATE(SCI_CASDEC_X);
    sci_type = SCI_GET<int>(p_casdec_x1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_CASDEC_X, "sci_type != SCI_CASDEC_X");

    p_fir_x1 = SCI_CREATE(SCI_FIR_X);
    p_fir_x2 = SCI_CREATE(SCI_FIR_X);
    p_fir_x3 = SCI_CREATE(SCI_FIR_X);
    p_cnt1 = SCI_CREATE(SCI_COUNTER);
    p_cnt2 = SCI_CREATE(SCI_COUNTER);
    p_cnt3 = SCI_CREATE(SCI_COUNTER);
    p_wgn_x1 = SCI_CREATE(SCI_WGN_X);

    // source - random mean = (0.0+j0.0) sigma =1.0
    x_x = SCI_GEN<cvec>(p_wgn_x1, ce); // source - random mean = (0.0+j0.0) sigma =1.0
    
    // discrete cascade settings
    SCI_SET(p_fir_x1, SCI_TAPS, c0);
    SCI_EXEC(p_fir_x1, SCI_RESET);
    SCI_SET(p_fir_x2, SCI_TAPS, c0);
    SCI_EXEC(p_fir_x2, SCI_RESET);
    SCI_SET(p_fir_x3, SCI_TAPS, c0);
    SCI_EXEC(p_fir_x3, SCI_RESET);
    SCI_SET(p_cnt1, SCI_PARAM_N, 2);
    SCI_EXEC(p_cnt1, SCI_RESET);
    SCI_SET(p_cnt2, SCI_PARAM_N, 2);
    SCI_EXEC(p_cnt2, SCI_RESET);
    SCI_SET(p_cnt3, SCI_PARAM_N, 2);
    SCI_EXEC(p_cnt3, SCI_RESET);
   
    // decimator settings
    SCI_SET(p_casdec_x1, SCI_ORDER, CAS_DEC_ORDER);
    SCI_SET(p_casdec_x1, SCI_TAPS, c0);
    SCI_EXEC(p_casdec_x1, SCI_RESET);
    
    // discrete cascade proc
    ya_x1 = SCI_PROC<cvec>(p_fir_x1, ce, x_x);
    ce1 = SCI_GEN<bvec>(p_cnt1, ce);
    ya_x2 = SCI_PROC<cvec>(p_fir_x2, ce1, ya_x1);
    ce2 = SCI_GEN<bvec>(p_cnt2, ce1);
    ya_x3 = SCI_PROC<cvec>(p_fir_x3, ce2, ya_x2);
    ce3 = SCI_GEN<bvec>(p_cnt3, ce2);
    ya.set_size(N, 2);
    ya.set_col(0, ya_x3);
    ya.set_col(1, to_cvec(to_vec(ce3), zeros(ce3.length())));
    debug(1) << "ya=" << endl << ya << endl;

    // decimator proc
    yb = SCI_PROC<cmat>(p_casdec_x1, ce, x_x);
    debug(1) << "yb=" << endl << yb << endl;

    itpp_sci_assert((abs(ya.get_col(0) - yb.get_col(0)) < epsilon) == true_vec, "yb(:,0) ! = ya(:,0)");
    itpp_sci_assert(to_bvec(real(ya.get_col(1))) == to_bvec(real(yb.get_col(1))), "yb(:,1) ! = ya(:,1)");

    SCI_DESTROY(p_fir_x1);
    SCI_DESTROY(p_fir_x2);
    SCI_DESTROY(p_fir_x3);
    SCI_DESTROY(p_cnt1);
    SCI_DESTROY(p_cnt2);
    SCI_DESTROY(p_cnt3);
    SCI_DESTROY(p_wgn_x1);
    SCI_DESTROY(p_casdec_x1);

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}



