/*!
* \brief - sci_circbuff, sci_circbuff_x test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <iomanip>

#include "itpp/itbase.h"

// ---- SIM  ----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_circbuff_x()
{
#ifdef _SCI_
  sci_base *p_cb1, *p_cb_x1;  
#else
  void *p_cb1, *p_cb_x1;
#endif

  const int  M = 3;    // short vector size
  const int  N = 10;   // long vector size

  double v;
  vec a, b, ref, out_vec, y, null_vec;
  complexd v_x;
  cvec a_x, b_x, ref_x, out_vec_x, y_x, null_cvec;

  bvec cei, ceo;
  bmat ceio;

  int err = 0;
  int sci_type;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_circbuff" << endl;
  try
  {
    cout << fixed << setw(3) << setprecision(1);

    a = linspace(0, M - 1, M);        // [0,1,2]
    debug(1) << "a = " << a << endl;
    b = linspace(M, N - 1, N - M);    // [3,4,5,6,7,8,9]
    debug(1) << "b = " << b << endl;
    ref = concat(a, b);               // [0,1,2,3,4,5,6,7,8,9]
    debug(1) << "ref = " << ref << endl;

    a_x = to_cvec(a);
    debug(1) << "a_x = " << a_x << endl;
    b_x = to_cvec(b);
    debug(1) << "b_x = " << b_x << endl;
    ref_x = concat(a_x, b_x);
    debug(1) << "ref_x = " << ref_x << endl;

    null_vec.set_length(0);
    null_cvec.set_length(0);

    p_cb1 = SCI_CREATE(SCI_CIRCBUFF);
    sci_type = SCI_GET<int>(p_cb1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_CIRCBUFF, "sci_type != SCI_CIRCBUFF");
    SCI_SET(p_cb1, SCI_SIZE, N);
    itpp_sci_assert(SCI_GET<int>(p_cb1, SCI_SIZE) == N, "cb1.get_size() != N");

    p_cb_x1 = SCI_CREATE(SCI_CIRCBUFF_X);
    sci_type = SCI_GET<int>(p_cb_x1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_CIRCBUFF_X, "sci_type != SCI_CIRCBUFF_X");
    SCI_SET(p_cb_x1, SCI_SIZE, N);
    itpp_sci_assert(SCI_GET<int>(p_cb_x1, SCI_SIZE) == N, "cb_x1.get_size() != N");

    // put [a|b] , peek, rev_peek, get(), get(), get(), get(-1), get(-1)
    SCI_SET(p_cb1, SCI_VEC, a);
    SCI_SET(p_cb1, SCI_VEC, b);
    out_vec = SCI_GET<vec>(p_cb1, SCI_PEEK_VEC);
    debug(1) << "peek(out_vec) = " << out_vec << endl;
    itpp_sci_assert(out_vec == ref, "peek(out_vec) != ref");

    out_vec = SCI_GET<vec>(p_cb1, SCI_PEEK_REV_VEC);
    debug(1) << "peek_reverse(out_vec) = " << out_vec << endl;
    itpp_sci_assert(out_vec == reverse(ref), "peek_reverse(out_vec) != reverse(ref)");

    v = SCI_GET<double>(p_cb1, SCI_SINGLETON);
    itpp_sci_assert(v == a[0], "v != a[0]");
    v = SCI_GET<double>(p_cb1, SCI_SINGLETON);
    itpp_sci_assert(v == a[1], "v != a[1]");
    v = SCI_GET<double>(p_cb1, SCI_SINGLETON);
    itpp_sci_assert(v == a[2], "v != a[2]");

    out_vec = SCI_GET<vec>(p_cb1, SCI_VEC);
    debug(1) << "get(out_vec) = " << out_vec << endl;
    itpp_sci_assert(out_vec == b, "out_vec != b");

    out_vec = SCI_GET<vec>(p_cb1, SCI_PEEK_VEC);
    debug(1) << "get(out_vec) = " << out_vec << endl;
    itpp_sci_assert(out_vec == null_vec, "out_vec != null_vec");

    // process(M cei ticks), gen(N ticks)
    cei = to_bvec(to_ivec(ones(M)));
    ceo = to_bvec(to_ivec(zeros(M)));
    ceio.set_size(M, 2);
    ceio.set_col(0, cei);
    ceio.set_col(1, ceo);

    debug(1) << "cb1.nrof_elements= " << SCI_GET<int>(p_cb1, SCI_N_OF_ELEM) << endl;
    itpp_sci_assert(SCI_GET<int>(p_cb1, SCI_N_OF_ELEM) == 0, "cb1.nrof_elements() != 0");

    y = SCI_PROC<vec>(p_cb1, ceio, a);

    itpp_sci_assert(y == zeros(M), "y == zeros(M)");

    debug(1) << "cb1.nrof_elements= " << SCI_GET<int>(p_cb1, SCI_N_OF_ELEM) << endl;
    itpp_sci_assert(SCI_GET<int>(p_cb1, SCI_N_OF_ELEM) == M, "cb1.nrof_elements() != M");

    cei = to_bvec(to_ivec(ones(N)));
    y = SCI_GEN<vec>(p_cb1, cei);
    ref = concat(concat(concat(a, a), a), a[0]);
    debug(1) << "y = " << y << endl;
    itpp_sci_assert(y == ref, "y != ref");

    // put [a|b] , peek, rev_peek, get(), get(), get(), get(-1), get(-1)

    SCI_SET(p_cb_x1, SCI_VEC, a_x);
    SCI_SET(p_cb_x1, SCI_VEC, b_x);
    out_vec_x = SCI_GET<cvec>(p_cb_x1, SCI_PEEK_VEC);
    debug(1) << "peek(out_vec_x) = " << out_vec_x << endl;
    itpp_sci_assert(out_vec_x == ref_x, "peek(out_vec_x) != ref_x");

    out_vec_x = SCI_GET<cvec>(p_cb_x1, SCI_PEEK_REV_VEC);
    debug(1) << "peek_reverse(out_vec_x) = " << out_vec_x << endl;
    itpp_sci_assert(out_vec_x == reverse(ref_x), "peek_reverse(out_vec_x) != reverse(ref_x)");

    v_x = SCI_GET<complexd>(p_cb_x1, SCI_SINGLETON);
    itpp_sci_assert(v_x == a_x[0], "v != a_x[0]");
    v_x = SCI_GET<complexd>(p_cb_x1, SCI_SINGLETON);
    itpp_sci_assert(v_x == a_x[1], "v != a_x[1]");
    v_x = SCI_GET<complexd>(p_cb_x1, SCI_SINGLETON);
    itpp_sci_assert(v_x == a_x[2], "v != a_x[2]");

    out_vec_x = SCI_GET<cvec>(p_cb_x1, SCI_VEC);
    debug(1) << "get(out_vec_x) = " << out_vec_x << endl;
    itpp_sci_assert(out_vec_x == b_x, "out_vec_x != b");

    out_vec_x = SCI_GET<cvec>(p_cb_x1, SCI_PEEK_VEC);
    debug(1) << "get(out_vec_x) = " << out_vec_x << endl;
    itpp_sci_assert(out_vec_x == null_cvec, "out_vec_x != null_vec");

    // process(M cei ticks), gen(N ticks)
    cei = to_bvec(to_ivec(ones(M)));
    ceo = to_bvec(to_ivec(zeros(M)));
    ceio.set_size(M, 2);
    ceio.set_col(0, cei);
    ceio.set_col(1, ceo);

    debug(1) << "cb_x1.nrof_elements= " << SCI_GET<int>(p_cb_x1, SCI_N_OF_ELEM) << endl;
    itpp_sci_assert(SCI_GET<int>(p_cb_x1, SCI_N_OF_ELEM) == 0, "cb_x1.nrof_elements() != 0");

    y_x = SCI_PROC<cvec>(p_cb_x1, ceio, a_x);

    itpp_sci_assert(y_x == to_cvec(zeros(M)), "y_x == zeros(M)");

    debug(1) << "cb_x1.nrof_elements= " << SCI_GET<int>(p_cb_x1, SCI_N_OF_ELEM) << endl;
    itpp_sci_assert(SCI_GET<int>(p_cb_x1, SCI_N_OF_ELEM) == M, "cb_x1.nrof_elements() != M");

    cei = to_bvec(to_ivec(ones(N)));
    y_x = SCI_GEN<cvec>(p_cb_x1, cei);
    ref_x = concat(concat(concat(a_x, a_x), a_x), a_x[0]);
    debug(1) << "y_x = " << y_x << endl;
    itpp_sci_assert(y_x == ref_x, "y_x != ref_x");


    SCI_DESTROY(p_cb1);
    SCI_DESTROY(p_cb_x1);

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
