/*!
* \brief - sci_cofdm_mod, sci_cofdm_dem, sci_cofdm_map, sci_cofdm_demap, sci_cofdm_sel test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ---- SIM  ----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_cofdm()
{

#ifdef _SCI_
  sci_base *p_cofdm_mod1, *p_cofdm_dem1, *p_cofdm_map1, *p_cofdm_demap1, *p_cofdm_sel1;
#else
  void *p_cofdm_mod1, *p_cofdm_dem1, *p_cofdm_map1, *p_cofdm_demap1, *p_cofdm_sel1;
#endif

  const int NFFT = 16; // NFFT
  const int CP = 4;    // CP 
  const int M = 4;     // QPSK

  cvec y_map, y_mod, y_dem;
  cmat m_map, m_mod, m_dem;

  ivec y_demap_data;
  bvec y_demap_pilots;
  cvec z_mod, z_dem;        // zero carriers  
  cvec cp_lead;             // CP = x[0:CP-1]
  cvec cp_trail;            // CP = x[NFFT:NFFT+CP-1]
  bvec true_vec;
  bvec ce;

  double epsilon = 1.0E-6;
  int sci_type;
  int err = 0;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_cofdm" << endl;
  try
  {
    debug(1) << "NFFT = " << NFFT << endl;
    debug(1) << "  CP = " << CP << endl;
    debug(1) << "   M = " << M << endl;

    p_cofdm_mod1 = SCI_CREATE(SCI_COFDM_MOD);
    sci_type = SCI_GET<int>(p_cofdm_mod1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_COFDM_MOD, "sci_type != SCI_COFDM_MOD");

    p_cofdm_dem1 = SCI_CREATE(SCI_COFDM_DEM);
    sci_type = SCI_GET<int>(p_cofdm_dem1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_COFDM_DEM, "sci_type != SCI_COFDM_DEM");

    p_cofdm_map1 = SCI_CREATE(SCI_COFDM_MAP);
    sci_type = SCI_GET<int>(p_cofdm_map1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_COFDM_MAP, "sci_type != SCI_COFDM_MAP");

    p_cofdm_demap1 = SCI_CREATE(SCI_COFDM_DEMAP);
    sci_type = SCI_GET<int>(p_cofdm_demap1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_COFDM_DEMAP, "sci_type != SCI_COFDM_DEMAP");

    p_cofdm_sel1 = SCI_CREATE(SCI_COFDM_SEL);
    sci_type = SCI_GET<int>(p_cofdm_sel1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_COFDM_SEL, "sci_type != SCI_COFDM_SEL");

    // set modulator
    SCI_SET(p_cofdm_mod1, SCI_COFDM_NFFT, NFFT);
    SCI_SET(p_cofdm_mod1, SCI_COFDM_CP, CP);
    // set demodulator
    SCI_SET(p_cofdm_dem1, SCI_COFDM_NFFT, NFFT);
    SCI_SET(p_cofdm_dem1, SCI_COFDM_CP, CP);
    // set mapper
    SCI_SET(p_cofdm_map1, SCI_COFDM_NFFT, NFFT);
    SCI_SET(p_cofdm_map1, SCI_COFDM_QAM_SIZE, M);
    // set mapper
    SCI_SET(p_cofdm_demap1, SCI_COFDM_NFFT, NFFT);
    SCI_SET(p_cofdm_demap1, SCI_COFDM_QAM_SIZE, M);
    // set sel
    SCI_SET(p_cofdm_sel1, SCI_COFDM_NFFT, NFFT);
    // z - zero carrier
    // p - pilot carrier
    // d - data carrier
    // 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
    // z p d d d p d d d p d  d  d  p  d  z
    ivec dcindx = " 2 3 4 6 7 8 10 11 12 14 ";
    ivec dc     = " 0 1 2 3 0 1 2  3  0  1  ";
    ivec zcindx = " 0 15 ";
    ivec pcindx = " 1 5 9 13";
    bvec pc     = " 0 1 0 1";
    debug(1) << " data_carriers dcindx = " << endl << dcindx << endl;
    debug(1) << " pilots_carriers pcindx = " << endl << pcindx << endl;
    debug(1) << " zero_carriers zcindx = " << endl << zcindx << endl;
    debug(1) << " data dc = " << endl << dc << endl;
    debug(1) << " pilots pc = " << endl << pc << endl;

    z_mod = to_cvec(zeros(zcindx.length()), zeros(zcindx.length()));
    true_vec = ones_b(zcindx.length());

    // set data pilots zero carrier indexes for map
    SCI_SET(p_cofdm_map1, SCI_COFDM_DATA_INDEXES, dcindx);
    SCI_SET(p_cofdm_map1, SCI_COFDM_PILOT_INDEXES, pcindx);
    SCI_SET(p_cofdm_map1, SCI_COFDM_ZERO_INDEXES, zcindx);
    // set data pilots zero carrier indexes for demap
    SCI_SET(p_cofdm_demap1, SCI_COFDM_DATA_INDEXES, dcindx);
    SCI_SET(p_cofdm_demap1, SCI_COFDM_PILOT_INDEXES, pcindx);
    SCI_SET(p_cofdm_demap1, SCI_COFDM_ZERO_INDEXES, zcindx);
    // set selected carriers for zero-carriers
    SCI_SET(p_cofdm_sel1, SCI_COFDM_SEL_INDEXES, zcindx);

    // test immediate interface 
    // map data/pilots into symbols
    SCI_SET(p_cofdm_map1, SCI_COFDM_DATA, dc);
    SCI_SET(p_cofdm_map1, SCI_COFDM_PILOTS, pc);
    y_map = SCI_GET<cvec>(p_cofdm_map1, SCI_COFDM_CARRIERS);
    debug(1) << "cofdm_map1.get_output() y_map = " << endl << y_map << endl;
    // modulate
    SCI_SET(p_cofdm_mod1, SCI_COFDM_CARRIERS, y_map);
    y_mod = SCI_GET<cvec>(p_cofdm_mod1, SCI_COFDM_SYMBOL);
    debug(1) << "cofdm_mod1.get_output() y_mod = " << endl << y_mod << endl;
 
    cp_lead = y_mod.left(CP);         // CP = x[0:CP-1]
    cp_trail = y_mod.right(CP);       // CP = x[NFFT:NFFT+CP-1]
    itpp_sci_assert(cp_lead == cp_trail, "cp_lead != cp_trail");
    
    // demodulate
    SCI_SET(p_cofdm_dem1, SCI_COFDM_SYMBOL, y_mod);
    y_dem = SCI_GET<cvec>(p_cofdm_dem1, SCI_COFDM_CARRIERS);
    debug(1) << "cofdm_dem1.get_output() y_dem = " << endl << y_dem << endl;
    // demap
    SCI_SET(p_cofdm_demap1, SCI_COFDM_CARRIERS, y_dem);
    y_demap_data = SCI_GET<ivec>(p_cofdm_demap1, SCI_COFDM_DATA);
    debug(1) << "cofdm_demap1.get_data() y_demap_data = " << endl << y_demap_data << endl;
    y_demap_pilots = SCI_GET<bvec>(p_cofdm_demap1, SCI_COFDM_PILOTS);
    debug(1) << "cofdm_demap1.get_pilots() y_demap_pilots = " << endl << y_demap_pilots << endl;
 
    // select zero carriers
    SCI_SET(p_cofdm_sel1, SCI_COFDM_CARRIERS, y_dem);
    z_dem = SCI_GET<cvec>(p_cofdm_sel1, SCI_COFDM_SEL_CARRIERS);
    debug(1) <<  "cofdm_sel1.get_sel() z_dem = " << endl << z_dem << endl;

    itpp_sci_assert(y_demap_data == dc, "y_demap_data != dc");
    itpp_sci_assert(y_demap_pilots == pc, "y_demap_pilots != pc");
    itpp_sci_assert((abs(z_dem - z_mod) < epsilon) == true_vec, "z_dem != z_mod");

    // test clocked interface with double tick
    ce = ones_b(2);
    imat m_pd, m_pd_dem;
    m_pd.set_size(2, pc.length() + dc.length());
    m_pd.set_row(0, concat(reverse(to_ivec(pc)), reverse(dc)));
    m_pd.set_row(1, concat(to_ivec(pc), dc));

    debug(1) << "m_pd = " << endl << m_pd << endl;
    m_map = SCI_PROC<cmat>(p_cofdm_map1, ce, m_pd);

    debug(1) << "my_map = " << endl << m_map << endl;
    itpp_sci_assert((abs(m_map.get_row(1) - y_map) < epsilon) == ones_b(NFFT), "my_map(1) != y_map");

    m_mod = SCI_PROC<cmat>(p_cofdm_mod1, ce, m_map);
    m_dem = SCI_PROC<cmat>(p_cofdm_dem1, ce, m_mod);
    m_pd_dem = SCI_PROC<imat>(p_cofdm_demap1, ce, m_dem);

    debug(1) << "m_pd_dem = " << endl << m_pd_dem << endl;
    itpp_sci_assert(m_pd_dem == m_pd, "m_pd_dem != m_pd");

    SCI_DESTROY(p_cofdm_mod1);
    SCI_DESTROY(p_cofdm_dem1);
    SCI_DESTROY(p_cofdm_map1);
    SCI_DESTROY(p_cofdm_demap1);
    SCI_DESTROY(p_cofdm_sel1);

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
