/*!
* \brief - sci_counter test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <fstream>
#include <iomanip>

// ---- ITPP  ----

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_counter()
{
#ifndef _SCI_
  void *p_cnt1;
#else
  sci_base *p_cnt1;
#endif

  const int N = 4;  // modulo
  const int M = 4 * N; // number of ticks

  int c0;
  bvec ce, y, yref;

  int i, sci_type;
  int err = 0;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_counter" << endl;
  try
  {
    p_cnt1 = SCI_CREATE(SCI_COUNTER);
    sci_type = SCI_GET<int>(p_cnt1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_COUNTER, "sci_type != SCI_COUNTER");

    // modulo
    SCI_SET(p_cnt1, SCI_PARAM_N, N);

    debug(1) << "counter modulo N =" << SCI_GET<int>(p_cnt1, SCI_PARAM_N) << endl;
    itpp_sci_assert(N == SCI_GET<int>(p_cnt1, SCI_PARAM_N) , "N != get_N()");

    ce.set_length(M);
    ce.ones();
    yref = zeros_b(M);
    for(c0 = 0, i = 0; i < M; i++)
    {
      c0++;
      if(c0 == N)
      {
        c0 = 0;
        yref[i] = 1;
      }
    }
    debug(1) << "ce =" << endl << ce << endl;
    debug(1) << "yref =" << endl << yref << endl;
    y = SCI_GEN<bvec>(p_cnt1, ce);
    debug(1) << "y =" << endl << y << endl;
    itpp_sci_assert(y == yref, "y != yref");

    // last bit in y is 1, so state must be 0
    c0 = SCI_GET<int>(p_cnt1, SCI_STATE);
    debug(1) << "c0 =" << c0 << endl;
    itpp_sci_assert(c0 == 0, "c0 != 0");

    SCI_SET(p_cnt1, SCI_STATE, N - 1);
    c0 = SCI_GET<int>(p_cnt1, SCI_STATE);

    debug(1) << "c0 =" << c0 << endl;
    itpp_sci_assert(c0 == N - 1, "c1 != N-1");

    SCI_EXEC(p_cnt1, SCI_RESET);
    c0 = SCI_GET<int>(p_cnt1, SCI_STATE);
    debug(1) << "c0 =" << c0 << endl;
    itpp_sci_assert(c0 == 0, "c0 != 0");

    SCI_DESTROY(p_cnt1);
  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;

}

