/*xxx
* \brief - sci_ejp test application
* \author maki
*/

// ----MSVC----
#include <iostream>
#include <fstream>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ---- SIM  ----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_ejp()
{
#ifdef _SCI_
  sci_base *p_nco1, *p_ejp1;  
#else
  void *p_nco1, *p_ejp1;
#endif

  const double L = 1.000;
  const double M = 4.0;
  const int    N = 2 * (int)M;
  const int    Nq_bits = 60;  // NCO phase accumulator format is Q1.Nq_bits

  bvec ce, true_vec;
  vec  x;
  mat nco_y;
  bvec nco_cy;
  vec nco_ph;
  cvec ejp_y, ejp_ref;
  cmat all;
  double epsilon = 1.0E-6;
  int err = 0;
  int sci_type;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_ejp" << endl;
  try
  {
    cout << fixed << setw(15) << setprecision(14);
    debug(1) << "epsilon =" << epsilon << endl;

    p_nco1 = SCI_CREATE(SCI_NCO);

    p_ejp1 = SCI_CREATE(SCI_EJP);
    sci_type = SCI_GET<int>(p_ejp1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_EJP, "ejp1.sci_type != SCI_EJP");


    SCI_SET(p_nco1, SCI_PARAM_N, Nq_bits);
    debug(1) << "nco1.get_N() =" << SCI_GET<int>(p_nco1, SCI_PARAM_N) << endl;
    itpp_sci_assert(SCI_GET<int>(p_nco1, SCI_PARAM_N) == Nq_bits, "nco1.get_N() != Nq_bits");

    ce.set_length(N);
    ce.ones();
    true_vec.set_length(N);
    true_vec.ones();

    x.set_length(N);
    x.ones();
    x = (L / M) * x;
    debug(1) << "L/M =" << L << "/" << M << endl;

    nco_y = SCI_PROC<mat>(p_nco1, ce, x);
    nco_cy = (nco_y.get_col(0) != zeros(N));
    nco_ph = nco_y.get_col(1);


    ejp_y = SCI_PROC<cvec>(p_ejp1, ce, nco_ph);
    ejp_ref = to_cvec(itpp::cos(2 * pi * nco_ph), itpp::sin(2 * pi * nco_ph));

    all.set_size(N, 2);
    all.set_col(0, ejp_y);
    all.set_col(1, ejp_ref);
    debug(3) << "[ejp_y|ejp_ref] = " << endl << all << endl;

    itpp_sci_assert((abs(itpp::real(ejp_y) - itpp::real(ejp_ref)) < epsilon) == true_vec, "abs(real(ejp_y) - real(ejp_ref)) > epsilon ");
    itpp_sci_assert((abs(itpp::imag(ejp_y) - itpp::imag(ejp_ref)) < epsilon) == true_vec, "abs(imag(ejp_y) - imag(ejp_ref)) > epsilon ");

    SCI_DESTROY(p_nco1);
    SCI_DESTROY(p_ejp1);

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
