/*xxx
* \brief - SCI FIR test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>

// ---- ITPP  ----
#include "sci\_sci_exception.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"


using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_fir()
{
#ifdef _SCI_
  sci_base *p_fir1;
#else
  void *p_fir1;
#endif

  const int TAPS = 5;
  const int N = 10;

  vec c0, c1;
  vec x;
  bvec ce;
  vec y, yref;
  vec z1;

  int sci_type;
  int err = 0;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_fir" << endl;
  try
  {
    c0 = ones(TAPS) * 0.1;
    x = zeros(N);
    x[0] = 1.0;
    ce.set_length(N);
    ce.ones();
    debug(1) << "x = " << x << endl;
    debug(1) << "c0 = " << c0 << endl;
    debug(1) << "ce = " << ce << endl;

    p_fir1 = SCI_CREATE(SCI_FIR);
    sci_type = SCI_GET<int>(p_fir1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_FIR, "sci_type != SCI_FIR");

    SCI_SET(p_fir1, SCI_TAPS, c0);
    SCI_EXEC(p_fir1, SCI_RESET);
    c1 = SCI_GET<vec>(p_fir1, SCI_TAPS);
    z1 = SCI_GET<vec>(p_fir1, SCI_STATE);
    debug(1) << "c1 = " << c1 << endl;
    debug(1) << "z1 = " << z1 << endl;
    itpp_sci_assert(c1 == c0, "c1 != c0");
    itpp_sci_assert(z1 == zeros(TAPS), "z1 != zeros(TAPS)");

    y = SCI_PROC<vec>(p_fir1, ce, x);
    yref = concat(c0, zeros(N - TAPS));
    debug(1) << "   y = " << y << endl;
    debug(1) << "yref = " << yref << endl;
    itpp_sci_assert(y == yref, "y != yref");

    SCI_DESTROY(p_fir1);
  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}


