/*xxx
* \brief - sci_fir_up test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <complex>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ---- SIM  ----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"


using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_fir_up()
{
#ifdef _SCI_
  sci_base *p_fir_up1, *p_fir_up_x1, *p_cnt1;
#else
  void *p_fir_up1, *p_fir_up_x1, *p_cnt1;
#endif

  const int TAPS = 8;
  const int N = 2 * TAPS;

  vec c0, c1, z1;
  cvec c_x0, c_x1;
  vec x;
  cvec x_x, z_x;
  bvec cei, ceo;
  bmat ce;
  vec y, y_ref;
  cvec y_x, y_x_ref;

  int sci_type;
  int err = 0;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_fir_up" << endl;
  try
  {
    p_cnt1 = SCI_CREATE(SCI_COUNTER);
    SCI_SET(p_cnt1, SCI_PARAM_N, TAPS);
    SCI_SET(p_cnt1, SCI_STATE, TAPS - 1);
    ceo.set_length(N);
    ceo.ones();
    // cei is out of by UP counter
    cei = SCI_GEN<bvec>(p_cnt1, ceo);
    // up sample
    ce.set_size(N, 2);
    ce.set_col(0, cei);
    ce.set_col(1, ceo);
    debug(1) << "ce.' = [cei|ceo].' \n" << ce.transpose() << endl;

    c0 = ones(TAPS) * (1.0 / TAPS);
    debug(1) << "c0 = " << c0 << endl;

    // set_up UP filter
    p_fir_up1 = SCI_CREATE(SCI_FIR_UP);
    sci_type = SCI_GET<int>(p_fir_up1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_FIR_UP, "sci_type != SCI_FIR_UP");
    SCI_SET(p_fir_up1, SCI_TAPS, c0);
    SCI_EXEC(p_fir_up1, SCI_RESET);
    c1 = SCI_GET<vec>(p_fir_up1, SCI_TAPS);
    z1 = SCI_GET<vec>(p_fir_up1, SCI_STATE);
    itpp_sci_assert(c1 == c0, "c1 != c0");
    itpp_sci_assert(z1 == zeros(TAPS), "z1 != zeros(TAPS)");

    // set up input signal
    x.set_length(N);
    x.ones();

    y = SCI_PROC<vec>(p_fir_up1, ce, x);
    //  y should be constant signal 0.125
    y_ref = ones(N) * (1.0 / TAPS);

    debug(1) << "    x = " << x << endl;
    debug(1) << "    y = " << y << endl;
    debug(1) << "y_ref = " << y_ref << endl;
    itpp_sci_assert(y == y_ref, "y != y_ref");

    // filter is complex MAV - 1/8
    c_x0 = to_cvec(c0, c0);
    debug(1) << "c_x0 = " << c_x0 << endl;
    // set up input signal
    x_x.set_length(N);
    x_x = to_cvec(x, zeros(N));

    p_fir_up_x1 = SCI_CREATE(SCI_FIR_UP_X);
    sci_type = SCI_GET<int>(p_fir_up_x1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_FIR_UP_X, "sci_type != SCI_FIR_UP_X");

    SCI_SET(p_fir_up_x1, SCI_TAPS, c_x0);
    SCI_EXEC(p_fir_up_x1, SCI_RESET);
    c_x1 = SCI_GET<cvec>(p_fir_up_x1, SCI_TAPS);
    z_x = SCI_GET<cvec>(p_fir_up_x1, SCI_STATE);

    itpp_sci_assert(c_x1 == c_x0, "c_x1 != c_x0");
    itpp_sci_assert(z_x == to_cvec(zeros(TAPS), zeros(TAPS)), "z_x != zeros(TAPS)");

    y_x = SCI_PROC<cvec>(p_fir_up_x1, ce, x_x);
    //  y should be constant signal 0.125+j0.125
    y_x_ref = to_cvec(ones(N), ones(N)) * (1.0 / TAPS);

    debug(1) << "    x_x =" << x_x << endl;
    debug(1) << "    y_x =" << y_x << endl;
    debug(1) << "y_x_ref =" << y_x_ref << endl;
    itpp_sci_assert(y_x == y_x_ref, "y_x != y_x_ref");

    SCI_DESTROY(p_cnt1);
    SCI_DESTROY(p_fir_up_x1);
    SCI_DESTROY(p_fir_up1);

  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}

