/*!
* \author maki
* \brief - sci_fir_x test application
*/

// ---- MSVC  ----
#include <iostream>
#include <complex>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ---- SIM  ----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "_sci_assert.hpp"
#include "sci\_sci_exception.hpp"

#include "__debug_level.h"
#include "debug.hpp"



using namespace std;
using namespace itpp;
using namespace SCI;


// scilab emulated code
int tf_sci_fir_x()
{

#ifdef _SCI_
  sci_base *p_firx1;
#else
  void *p_firx1;
#endif

  const int TAPS = 5;
  const int N = 10;
  cvec c0, c1;
  cvec x;
  bvec ce;
  cvec y, yref;
  cvec z1, zx;

  int sci_type;
  int err = 0;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_fir_x" << endl;
  try
  {
    c0 = 0.1 * to_cvec(ones(TAPS), ones(TAPS));
    x = to_cvec(zeros(N), zeros(N));
    x[0] = complexd(1.0, 0.0);
    ce.set_length(N);
    ce.ones();
    debug(1) << "x = " << x << endl;
    debug(1) << "c0 = " << c0 << endl;
    debug(1) << "ce = " << ce << endl;

    p_firx1 = SCI_CREATE(SCI_FIR_X);
    sci_type = SCI_GET<int>(p_firx1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_FIR_X, "sci_type != SCI_FIR_X");

    SCI_SET(p_firx1, SCI_TAPS, c0);
    SCI_EXEC(p_firx1, SCI_RESET);
    c1 = SCI_GET<cvec>(p_firx1, SCI_TAPS);
    z1 = SCI_GET<cvec>(p_firx1, SCI_STATE);
    debug(1) << "c1 = " << c1 << endl;
    debug(1) << "z1 = " << z1 << endl;
    itpp_sci_assert(c1 == c0, "c1 != c0");
    zx = to_cvec(zeros(TAPS), zeros(TAPS));
    itpp_sci_assert(z1 == zx, "z1 != zeros(TAPS)");
    y = SCI_PROC<cvec>(p_firx1, ce, x);
    zx = to_cvec(zeros(N - TAPS), zeros(N - TAPS));
    yref = concat(c0, zx);
    debug(1) << "   y = " << y << endl;
    debug(1) << "yref = " << yref << endl;
    itpp_sci_assert(y == yref, "y != yref");

    SCI_DESTROY(p_firx1);
  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }

  return err;
}
