/*!
* \brief - sci_iq2ap, sci_ap2iq test application
* \author maki
*/

// ----MSVC----
#include <iostream>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ---- SIM  ----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_iq2ap()
{
#ifdef _SCI_
  sci_base *p_qmod1, *p_qdem1, *p_iq2ap1, *p_ap2iq1;
#else
  void *p_qmod1, *p_qdem1, *p_iq2ap1, *p_ap2iq1;
#endif

  const int     M = 16;     // Symbol size Q16

  bvec ce, true_vec;
  cvec cv;
  mat ap;
  cvec iq;
  ivec ivx, ivy;
  mat y;

  int err = 0;
  int sci_type;
  double epsilon = 1.0E-6;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_iq2ap" << endl;
  try
  {
    cout << fixed << setw(7) << setprecision(3);
    debug(1) << "epsilon = " << epsilon << endl;
    debug(1) << "QAM size M = " << M << endl;

    ce.set_length(M);
    ce.ones();
    true_vec.set_length(M);
    true_vec.ones();

    p_qmod1 = SCI_CREATE(SCI_QAM_MOD);
    p_qdem1 = SCI_CREATE(SCI_QAM_DEM);
    SCI_SET(p_qmod1, SCI_SIZE, M);
    SCI_SET(p_qdem1, SCI_SIZE, M);

    p_iq2ap1 = SCI_CREATE(SCI_IQ2AP);
    sci_type = SCI_GET<int>(p_iq2ap1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_IQ2AP, "sci_type != SCI_IQ2AP");
    
    p_ap2iq1 = SCI_CREATE(SCI_AP2IQ);
    sci_type = SCI_GET<int>(p_ap2iq1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_AP2IQ, "sci_type != SCI_IQ2AP");

    ivx = to_ivec(linspace(0, M - 1, M));
    cv =  SCI_PROC<cvec>(p_qmod1, ce, ivx);
    ap =  SCI_PROC<mat>(p_iq2ap1, ce, cv);
    iq =  SCI_PROC<cvec>(p_ap2iq1, ce, ap);
    ivy = SCI_PROC<ivec>(p_qdem1, ce, iq);

    y.set_size(M, 8);
    y.set_col(0, to_vec(ivx));
    y.set_col(1, to_vec(ivy));
    y.set_col(2, real(cv));
    y.set_col(3, imag(cv));
    y.set_col(4, real(iq));
    y.set_col(5, imag(iq));
    y.set_col(6, ap.get_col(0));
    y.set_col(7, ap.get_col(1));
    debug(1) << "y  = " << endl;
    debug(1) << y << endl;

    itpp_sci_assert(ivx == ivy, "ivx!=ivy");
    itpp_sci_assert((abs(cv - iq) < epsilon) == true_vec, "cv!=iq");

    SCI_DESTROY(p_qmod1);
    SCI_DESTROY(p_qdem1);
    SCI_DESTROY(p_iq2ap1);
    SCI_DESTROY(p_ap2iq1);

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
