/*!
* \brief - sci_lfsr test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>

// ---- ITPP  ----

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_lfsr()
{
#ifdef _SCI_
  sci_base *p_lfsr1;
#else
  void *p_lfsr1;
#endif

  int N, M, W, W1, L, i;
  bvec c0, c1, z0, z1;
  bvec ce;
  bmat y1, y2, yref1, yref2;
  bool reverse_flag;

  int sci_type;
  int err = 0;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_lfsr" << endl;
  try
  {

    // J.83B standard - PRBS randomizer
    //         1+X3+X4
    //         0 1 2 3 4
    c0 = bvec("1 0 0 1 1");
    L = c0.length() - 1;
    M = ((int)pow(2.0, L) - 1);  // prbs sequence length
    W = M;                       // symbol size == prbs sequence

    p_lfsr1 = SCI_CREATE(SCI_LFSR);
    sci_type = SCI_GET<int>(p_lfsr1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_LFSR, "sci_type != SCI_LFSR");

    // minimal setup set_taps()/prbs() and set_symbol_size()
    debug(1) << "PRBS sequence lenght M =" << M << endl;
    debug(1) << "c0 = " << c0 << endl;
    SCI_SET(p_lfsr1, SCI_POLY, c0);
    debug(1) << "set_symbol_size == PRBS sequence W =" << W << endl;
    SCI_SET(p_lfsr1, SCI_SYMBOL_SIZE, W);


    c1 = SCI_GET<bvec>(p_lfsr1, SCI_POLY);
    debug(1) << "c1 = " << c0 << endl;
    itpp_sci_assert(c1 == c0, "c1 != c0");

    reverse_flag = SCI_GET<bool>(p_lfsr1, SCI_REVERSE_FLAG);
    debug(1) << "revese flag =" << reverse_flag << endl;
    itpp_sci_assert(reverse_flag, "reverse_flag != true");

    // reset is done by set_poly
    // state 1 is translated to [001] when reverse_flag is set (default)
    // convention for lfsr: for poly =[g0,g1,g2,g3,...]  state s0 = [s1,s2,s3,..,]  (no s^0 !)
    z0.set_length(L);
    z0 = dec2bin(L, 1);
    z1 = SCI_GET<bvec>(p_lfsr1, SCI_STATE);
    debug(1) << "z0 = " << z0 << endl;
    debug(1) << "z1 = " << z1 << endl;
    itpp_sci_assert(z1 == z0, "z1 != z0");

    W1 = SCI_GET<int>(p_lfsr1, SCI_SYMBOL_SIZE);
    debug(1) << "get_symbol_size W1 =" << W1 << endl;
    itpp_sci_assert(W1 == W, "W1 != W");

    // number of ticks == number of symbols
    N = 4;
    ce.set_length(N);
    ce.ones();
    // one symbol is whole PRBS sequence, so you should get N identical symbols
    yref1.set_size(N, W);
    debug(1) << "number_of ticks == number of symbols N =" << N << endl;

    for(i = 0; i < N; i++)
    {
      yref1.set_row(i, reverse(bvec("0 0 1 1 0 1 0 1 1 1 1 0 0 0 1")));
    }
    debug(1) << "yref1 =" << endl << yref1 << endl;

    y1 = SCI_GEN<bmat>(p_lfsr1, ce);
    debug(1) << "y1 =" << endl << y1 << endl;
    itpp_sci_assert(y1 == yref1, "y1 != yref1");

    SCI_SET(p_lfsr1, SCI_REVERSE_FLAG, false);
    debug(1) << "revese flag =" << SCI_GET<bool>(p_lfsr1, SCI_REVERSE_FLAG) << endl;
    itpp_sci_assert(!SCI_GET<bool>(p_lfsr1, SCI_REVERSE_FLAG), "lfsr1.get_rev_flag() != false");

    // one symbol is whole PRBS sequence, so you should get N identical symbols
    yref2.set_size(N, W);
    for(i = 0; i < N; i++)
    {
      yref2.set_row(i, bvec("0 0 1 1 0 1 0 1 1 1 1 0 0 0 1"));
    }
    debug(1) << "yref2 =" << endl << yref2 << endl;
    y2 = SCI_GEN<bmat>(p_lfsr1, ce);
    debug(1) << "y2 =" << endl << y2 << endl;
    itpp_sci_assert(y2 == yref2, "y2 != yref2");

    SCI_DESTROY(p_lfsr1);
  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
