/*!
* \brief - sci_lsr test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>

// ---- ITPP  ----

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_lsr()
{
#ifdef _SCI_
  sci_base *p_lsr1, *p_lfsr1;
#else
  void *p_lsr1, *p_lfsr1;
#endif

  int N, W, L, PRBS, D, T;
  bvec z0, z1;
  bvec ce, ce_ref;
  bmat y, x, x_ref, y_ref;

  int sci_type;
  int err = 0;


  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_lsr" << endl;

  try
  {
    // Symbol size
    W = 4;
    // LSR FIFO length in symbols
    D = 3;
    // ----------------------------------
    // set LSR memory length
    L = D * W;
    // clock ticks
    N = 2 * D;
    // test patterns by prbs generator 2^4-1
    PRBS = 4;

    p_lfsr1 = SCI_CREATE(SCI_LFSR);
    sci_type = SCI_GET<int>(p_lfsr1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_LFSR, "sci_type != SCI_LFSR");

    p_lsr1 = SCI_CREATE(SCI_LSR);
    sci_type = SCI_GET<int>(p_lsr1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_LSR, "sci_type != SCI_LSR");

    // set length and symbol_size as minimal setup
    debug(1) << "lsr1.set_length=" << L << endl;
    SCI_SET(p_lsr1, SCI_LENGTH, L);
    debug(1) << "lsr1.set_symbol_size=" << W << endl;
    SCI_SET(p_lsr1, SCI_SYMBOL_SIZE, W);

    T = SCI_GET<int>(p_lsr1, SCI_LENGTH);
    debug(1) << "lsr1.get_lenth() T =" << T << endl;
    itpp_sci_assert(T == L, "T != L");

    T = SCI_GET<int>(p_lsr1, SCI_SYMBOL_SIZE);
    debug(1) << "lsr1.get_symbol_size() T =" << T << endl;
    itpp_sci_assert(T == W, "T != W");

    // set LFSR as prbs generator
    debug(1) << "lsfr1.set_prbs PRBS=" << PRBS << endl;
    SCI_SET(p_lfsr1, SCI_PRBS, PRBS);
    debug(1) << "lsfr1.set_symbol_size W=" << W << endl;
    SCI_SET(p_lfsr1, SCI_SYMBOL_SIZE, W);

    // generate ce
    ce.set_length(N);
    ce.ones();
    // generate symbols
    x = SCI_GEN<bmat>(p_lfsr1, ce);
    x_ref = bmat("1 1 0 0; 1 0 1 0; 0 1 1 1; 0 1 0 0; 0 1 1 0; 1 1 0 1");
    ce_ref = bvec("1 1 1 1 1 1");
    y_ref = bmat("0 0 0 0; 0 0 0 0; 0 0 0 0; 1 1 0 0; 1 0 1 0; 0 1 1 1");
    debug(1) << "   ce = \n" << ce << endl;
    debug(1) << "    x = \n" << x << endl;
    debug(1) << " xref = \n" << x_ref << endl;
    itpp_sci_assert(x == x_ref, "x != x_ref");
    itpp_sci_assert(ce == ce_ref, "ce != ce_ref");

    y = SCI_PROC<bmat>(p_lsr1, ce, x);

    debug(1) << "    y = \n" << y << endl;
    debug(1) << "y_ref = \n" << y_ref << endl;
    itpp_sci_assert(y == y_ref, "y != y_ref");

    SCI_DESTROY(p_lfsr1);
    SCI_DESTROY(p_lsr1);
  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
